/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator.payload;

import com.google.protobuf.ByteString;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.eclipse.kapua.kura.simulator.payload.Metric;
import org.eclipse.kapua.kura.simulator.payload.Optional;
import org.eclipse.kura.core.message.protobuf.KuraPayloadProto;

public final class Metrics {
    public static final String KEY_REQUESTER_CLIENT_ID = "requester.client.id";
    public static final String KEY_REQUEST_ID = "request.id";
    public static final String KEY_RESPONSE_CODE = "response.code";
    public static final String KEY_RESPONSE_EXCEPTION_MESSAGE = "response.exception.message";
    public static final String KEY_RESPONSE_EXCEPTION_STACKTRACE = "response.exception.stack";

    private Metrics() {
    }

    public static void buildMetrics(KuraPayloadProto.KuraPayload.Builder builder, Map<String, Object> metrics) {
        Objects.requireNonNull(metrics);
        for (Map.Entry<String, Object> metric : metrics.entrySet()) {
            Metrics.addMetric(builder, metric.getKey(), metric.getValue());
        }
    }

    public static void addMetric(KuraPayloadProto.KuraPayload.Builder builder, String key, Object value) {
        KuraPayloadProto.KuraPayload.KuraMetric.Builder b = KuraPayloadProto.KuraPayload.KuraMetric.newBuilder();
        b.setName(key);
        if (value != null) {
            if (value instanceof Boolean) {
                b.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.BOOL);
                b.setBoolValue((Boolean)value);
            } else if (value instanceof Integer) {
                b.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.INT32);
                b.setIntValue((Integer)value);
            } else if (value instanceof String) {
                b.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.STRING);
                b.setStringValue((String)value);
            } else if (value instanceof Long) {
                b.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.INT64);
                b.setLongValue((Long)value);
            } else if (value instanceof Double) {
                b.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.DOUBLE);
                b.setDoubleValue((Double)value);
            } else if (value instanceof Float) {
                b.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.FLOAT);
                b.setFloatValue(((Float)value).floatValue());
            } else if (value instanceof byte[]) {
                b.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.BYTES);
                b.setBytesValue(ByteString.copyFrom((byte[])value));
            } else {
                throw new IllegalArgumentException(String.format("Illegal metric data type: %s", value.getClass()));
            }
        }
        if (value != null) {
            builder.addMetric(b);
        }
    }

    public static Map<String, Object> extractMetrics(KuraPayloadProto.KuraPayload payload) {
        if (payload == null) {
            return null;
        }
        return Metrics.extractMetrics(payload.getMetricList());
    }

    public static Map<String, Object> extractMetrics(List<KuraPayloadProto.KuraPayload.KuraMetric> metricList) {
        if (metricList == null) {
            return null;
        }
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (KuraPayloadProto.KuraPayload.KuraMetric metric : metricList) {
            String name = metric.getName();
            switch (metric.getType()) {
                case BOOL: {
                    result.put(name, metric.getBoolValue());
                    break;
                }
                case BYTES: {
                    result.put(name, metric.getBytesValue().toByteArray());
                    break;
                }
                case DOUBLE: {
                    result.put(name, metric.getDoubleValue());
                    break;
                }
                case FLOAT: {
                    result.put(name, Float.valueOf(metric.getFloatValue()));
                    break;
                }
                case INT32: {
                    result.put(name, metric.getIntValue());
                    break;
                }
                case INT64: {
                    result.put(name, metric.getLongValue());
                    break;
                }
                case STRING: {
                    result.put(name, metric.getStringValue());
                }
            }
        }
        return result;
    }

    public static String getAsString(Map<String, Object> metrics, String key) {
        return Metrics.getAsString(metrics, key, null);
    }

    public static String getAsString(Map<String, Object> metrics, String key, String defaultValue) {
        Object value = metrics.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    public static <T> T readFrom(T object, Map<String, Object> metrics) {
        Object value;
        boolean optional;
        Metric m;
        Objects.requireNonNull(object);
        for (Field field : FieldUtils.getFieldsListWithAnnotation(object.getClass(), Metric.class)) {
            m = field.getAnnotation(Metric.class);
            optional = field.isAnnotationPresent(Optional.class);
            value = metrics.get(m.value());
            if (value == null && !optional) {
                throw new IllegalArgumentException(String.format("Field '%s' is missing metric '%s'", field.getName(), m.value()));
            }
            if (value == null) continue;
            try {
                FieldUtils.writeField(field, object, value, true);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Failed to assign '%s' (%s) to field '%s'", value, value.getClass().getName(), field.getName()), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        for (Method method : MethodUtils.getMethodsListWithAnnotation(object.getClass(), Metric.class)) {
            m = method.getAnnotation(Metric.class);
            optional = method.isAnnotationPresent(Optional.class);
            value = metrics.get(m.value());
            if (value == null && !optional) {
                throw new IllegalArgumentException(String.format("Method '%s' is missing metric '%s'", method.getName(), m.value()));
            }
            if (value == null) continue;
            try {
                method.invoke(object, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Failed to call '%s' (%s) with method '%s'", value, value.getClass().getName(), method.getName()), e);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return object;
    }
}

