/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator.payload;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.kapua.kura.simulator.topic.Topic;
import org.eclipse.kapua.kura.simulator.util.Hex;

public class Message {
    private final Topic topic;
    private final byte[] payload;
    private final Map<String, String> topicContext;

    public Message(Topic topic, byte[] payload) {
        this(topic, payload, Collections.emptyMap());
    }

    public Message(Topic topic, byte[] payload, Map<String, String> topicContext) {
        this.topic = topic;
        this.payload = payload;
        this.topicContext = topicContext;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public Message localize(Topic topic) {
        return this.localize(topic, this.topicContext);
    }

    public Message localize(Topic topic, Map<String, String> topicContext) {
        LinkedList<Topic.Segment> newTopic = new LinkedList<Topic.Segment>(this.topic.getSegments());
        for (Topic.Segment seg : topic.getSegments()) {
            String segValue2;
            String segValue1 = this.topic.renderSegment(newTopic.removeFirst(), topicContext);
            if (segValue1.equals(segValue2 = topic.renderSegment(seg, topicContext))) continue;
            return null;
        }
        return new Message(Topic.from(newTopic), this.payload);
    }

    public String toString() {
        return String.format("[%s -> %s]", this.topic, Hex.toHex(this.payload, 256));
    }
}

