/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator.app.deploy;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.eclipse.kapua.kura.simulator.app.Request;
import org.eclipse.kapua.kura.simulator.app.deploy.AbstractDeployApplication;
import org.eclipse.kapua.kura.simulator.app.deploy.BundleInformation;
import org.eclipse.kapua.kura.simulator.app.deploy.DeploymentDownloadPackageRequest;
import org.eclipse.kapua.kura.simulator.app.deploy.DeploymentInstallPackageRequest;
import org.eclipse.kapua.kura.simulator.app.deploy.DeploymentPackageInformation;
import org.eclipse.kapua.kura.simulator.app.deploy.DeploymentUninstallPackageRequest;
import org.eclipse.kapua.kura.simulator.app.deploy.DownloadSimulator;
import org.eclipse.kapua.kura.simulator.app.deploy.DownloadState;
import org.eclipse.kapua.kura.simulator.app.deploy.InstallState;

public class SimpleDeployApplication
extends AbstractDeployApplication
implements AutoCloseable {
    private final Map<Long, BundleState> bundles = new TreeMap<Long, BundleState>();
    private final List<DeploymentPackageInformation> packages = new LinkedList<DeploymentPackageInformation>();
    private final DownloadSimulator downloadSimulator;
    private long nextFreeBundleId = 0L;

    public SimpleDeployApplication(ScheduledExecutorService downloadExecutor) {
        this.downloadSimulator = new DownloadSimulator(downloadExecutor, 10240L);
        this.bundles.put(this.nextFreeBundleId++, new BundleState("org.osgi", "6.0.0", 32));
        this.bundles.put(this.nextFreeBundleId++, new BundleState("org.eclipse.kura.api", "2.1.0", 32));
        this.bundles.put(this.nextFreeBundleId++, new BundleState("org.eclipse.kura.core", "2.1.1", 32));
        this.bundles.put(this.nextFreeBundleId++, new BundleState("org.eclipse.kura.unresolved", "2.1.2", 2));
        this.bundles.put(this.nextFreeBundleId++, new BundleState("org.eclipse.kura.unstarted", "2.1.1", 4));
    }

    public SimpleDeployApplication(ScheduledExecutorService downloadExecutor, List<BundleState> bundles) {
        this.downloadSimulator = new DownloadSimulator(downloadExecutor, 10240L);
        if (bundles != null) {
            for (BundleState bundle : bundles) {
                this.internalInstallBundle(bundle);
            }
        }
    }

    @Override
    public void close() {
        this.downloadSimulator.close();
    }

    @Override
    protected void executeDownload(Request request, DeploymentDownloadPackageRequest downloadRequest) {
        request.replySuccess().send();
        boolean started = this.downloadSimulator.startDownload(downloadRequest.getJobId(), 131072L, state -> request.notification("download").send(SimpleDeployApplication.toMetrics(state)), () -> this.internalInstallPackage(downloadRequest.getName(), downloadRequest.getVersion(), this.bundles(downloadRequest.getName(), downloadRequest.getVersion(), 10)));
        if (!started) {
            request.replyError().send(Collections.singletonMap("download.status", "IN_PROGRESS"), "Download already in progress".getBytes(StandardCharsets.UTF_8));
        } else {
            request.replySuccess().send();
        }
    }

    private List<DeploymentPackageInformation.BundleInformation> bundles(String baseName, String version, int count) {
        if (count <= 0) {
            return Collections.emptyList();
        }
        ArrayList<DeploymentPackageInformation.BundleInformation> result = new ArrayList<DeploymentPackageInformation.BundleInformation>(count);
        for (int i = 0; i < count; ++i) {
            String name = String.format("%s.%s", baseName, i);
            result.add(new DeploymentPackageInformation.BundleInformation(name, version));
        }
        return result;
    }

    @Override
    protected void cancelDownload(Request request) {
        if (this.downloadSimulator.cancelDownload()) {
            request.replySuccess().send();
        }
    }

    @Override
    protected void executeInstall(Request request, DeploymentInstallPackageRequest installRequest) {
        request.replySuccess().send();
    }

    @Override
    protected void executeUninstall(Request request, DeploymentUninstallPackageRequest uninstallRequest) {
        request.replySuccess().send();
        this.internalUninstallPackage(uninstallRequest.getName(), uninstallRequest.getVersion());
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("dp.uninstall.status", "COMPLETED");
        metrics.put("dp.uninstall.progress", 100);
        metrics.put("dp.name", uninstallRequest.getName());
        metrics.put("job.id", uninstallRequest.getJobId());
        request.notification("uninstall").send(metrics);
    }

    protected void internalInstallPackage(String name, String version, List<DeploymentPackageInformation.BundleInformation> bundles) {
        this.internalUninstallPackage(name, version);
        this.packages.add(new DeploymentPackageInformation(name, version, bundles));
        for (DeploymentPackageInformation.BundleInformation bi : bundles) {
            this.internalInstallBundle(new BundleState(bi.getSymbolicName(), bi.getVersion(), 32));
        }
    }

    protected void internalUninstallPackage(String name, String version) {
        Iterator<DeploymentPackageInformation> i = this.packages.iterator();
        while (i.hasNext()) {
            DeploymentPackageInformation p = i.next();
            if (!p.getSymbolicName().equals(name) || !p.getVersion().equals(version)) continue;
            i.remove();
            for (DeploymentPackageInformation.BundleInformation bi : p.getBundles()) {
                this.internallUninstallBundle(bi.getSymbolicName(), bi.getVersion());
            }
        }
    }

    protected void internalInstallBundle(BundleState bundle) {
        this.bundles.put(this.nextFreeBundleId++, bundle);
    }

    protected void internallUninstallBundle(String symbolicName, String version) {
        Iterator<Map.Entry<Long, BundleState>> i = this.bundles.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Long, BundleState> e = i.next();
            BundleState b = e.getValue();
            if (!b.getSymbolicName().equals(symbolicName) || !b.getVersion().equals(version)) continue;
            i.remove();
            return;
        }
    }

    @Override
    protected List<DeploymentPackageInformation> getPackages() {
        return Collections.unmodifiableList(this.packages);
    }

    @Override
    protected Optional<DownloadState> getDownloadState() {
        return Optional.ofNullable(this.downloadSimulator.getState());
    }

    @Override
    protected Optional<InstallState> getInstallState() {
        return Optional.empty();
    }

    @Override
    protected List<BundleInformation> getBundles() {
        return this.bundles.entrySet().stream().map(entry -> new BundleInformation(((BundleState)entry.getValue()).getSymbolicName(), ((BundleState)entry.getValue()).getVersion(), (Long)entry.getKey(), ((BundleState)entry.getValue()).getState())).collect(Collectors.toList());
    }

    @Override
    protected boolean startBundle(long bundleId) {
        BundleState bundle = this.bundles.get(bundleId);
        if (bundle == null) {
            return false;
        }
        if (bundle.getState() == 4) {
            bundle.setState(32);
        }
        return true;
    }

    @Override
    protected boolean stopBundle(long bundleId) {
        BundleState bundle = this.bundles.get(bundleId);
        if (bundle == null) {
            return false;
        }
        if (bundle.getState() == 32) {
            bundle.setState(4);
        }
        return true;
    }

    public static class BundleState {
        private final String symbolicName;
        private final String version;
        private int state;

        public BundleState(String symbolicName, String version, int state) {
            this.symbolicName = symbolicName;
            this.version = version;
            this.state = state;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

