/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator.app.deploy;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.kapua.kura.simulator.app.deploy.DownloadState;

public class DownloadSimulator
implements AutoCloseable {
    private final ScheduledExecutorService executor;
    private Job job;
    private final long bytesPerSecond;

    public DownloadSimulator(ScheduledExecutorService executor, long bytesPerSecond) {
        this.executor = executor;
        this.bytesPerSecond = bytesPerSecond;
    }

    public synchronized boolean startDownload(long jobId, long totalBytes, Consumer<DownloadState> consumer, Runnable whenCompleted) {
        if (this.job != null) {
            return false;
        }
        this.job = new Job(this.executor.scheduleAtFixedRate(this::tick, 0L, 1L, TimeUnit.SECONDS), totalBytes, jobId, consumer, whenCompleted);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelDownload() {
        Job job;
        DownloadState state;
        DownloadSimulator downloadSimulator = this;
        synchronized (downloadSimulator) {
            if (this.job == null) {
                return false;
            }
            this.job.cancel();
            state = this.job.getState();
            job = this.job;
            this.job = null;
        }
        if (job.consumer != null) {
            job.consumer.accept(state);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tick() {
        DownloadState state;
        DownloadSimulator downloadSimulator = this;
        synchronized (downloadSimulator) {
            if (this.job == null) {
                return;
            }
            this.job.tick();
            state = this.job.getState();
        }
        if (this.job.consumer != null) {
            this.job.consumer.accept(state);
        }
    }

    @Override
    public synchronized void close() {
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
    }

    public synchronized DownloadState getState() {
        if (this.job == null) {
            return DownloadState.DONE;
        }
        return this.job.getState();
    }

    private class Job {
        private final long totalBytes;
        private long currentBytes;
        private final ScheduledFuture<?> future;
        private JobState state = JobState.RUNNING;
        private final long jobId;
        private final Consumer<DownloadState> consumer;
        private final Runnable whenCompleted;

        public Job(ScheduledFuture<?> future, long totalBytes, long jobId, Consumer<DownloadState> consumer, Runnable whenCompleted) {
            this.future = future;
            this.totalBytes = totalBytes;
            this.jobId = jobId;
            this.consumer = consumer;
            this.whenCompleted = whenCompleted;
        }

        public void tick() {
            if (this.state != JobState.RUNNING) {
                return;
            }
            this.currentBytes += DownloadSimulator.this.bytesPerSecond;
            if (this.currentBytes >= this.totalBytes) {
                this.currentBytes = this.totalBytes;
                this.future.cancel(false);
                this.state = JobState.COMPLETED;
                if (this.whenCompleted != null) {
                    DownloadSimulator.this.executor.execute(this.whenCompleted);
                }
            }
        }

        public void cancel() {
            this.future.cancel(false);
            this.state = JobState.CANCELED;
        }

        public DownloadState getState() {
            switch (this.state) {
                case RUNNING: {
                    return new DownloadState((int)this.totalBytes, (int)(this.getCompletion() * 100.0), "IN_PROGRESS", this.jobId);
                }
                case CANCELED: {
                    return new DownloadState(0, 0, "CANCELLED", this.jobId);
                }
                case COMPLETED: {
                    return new DownloadState(0, 100, "COMPLETED", this.jobId);
                }
                case FAILED: {
                    return new DownloadState(0, 0, "FAILED", this.jobId);
                }
            }
            return DownloadState.DONE;
        }

        private double getCompletion() {
            return (double)this.currentBytes / (double)this.totalBytes;
        }
    }

    public static enum JobState {
        RUNNING,
        COMPLETED,
        CANCELED,
        FAILED;

    }
}

