/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator.app.command;

import java.util.HashMap;
import java.util.Objects;
import org.eclipse.kapua.kura.simulator.app.AbstractDefaultApplication;
import org.eclipse.kapua.kura.simulator.app.Request;
import org.eclipse.kapua.kura.simulator.payload.Metrics;

public abstract class AbstractCommandApplication
extends AbstractDefaultApplication {
    public abstract Result executeCommand(String var1);

    public AbstractCommandApplication() {
        super("CMD-V1");
    }

    @Override
    protected void processRequest(Request request) {
        if (!"EXEC/command".equals(request.getMessage().getTopic().render(0, 2))) {
            request.replyNotFound();
            return;
        }
        String command = Metrics.getAsString(request.getMetrics(), "command.command");
        Result resultValue = this.executeCommand(command);
        if (resultValue == null) {
            throw new IllegalStateException("Failed to execute command");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("command.stdout", resultValue.getStandardOutput());
        result.put("command.stderr", resultValue.getStandardError());
        result.put("command.exit.code", resultValue.getReturnCode());
        result.put("command.timedout", resultValue.isTimeout());
        request.replySuccess().send(result);
    }

    public static class Result {
        private final String standardOutput;
        private final String standardError;
        private final int returnCode;
        private final boolean timeout;

        public Result(String standardOutput, String standardError, int returnCode, boolean timeout) {
            Objects.requireNonNull(standardOutput);
            Objects.requireNonNull(standardError);
            this.standardOutput = standardOutput;
            this.standardError = standardError;
            this.returnCode = returnCode;
            this.timeout = timeout;
        }

        public String getStandardOutput() {
            return this.standardOutput;
        }

        public String getStandardError() {
            return this.standardError;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public boolean isTimeout() {
            return this.timeout;
        }
    }
}

