/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator.app.annotated;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.kapua.kura.simulator.app.AbstractDefaultApplication;
import org.eclipse.kapua.kura.simulator.app.Request;
import org.eclipse.kapua.kura.simulator.app.annotated.Application;
import org.eclipse.kapua.kura.simulator.app.annotated.DELETE;
import org.eclipse.kapua.kura.simulator.app.annotated.EXECUTE;
import org.eclipse.kapua.kura.simulator.app.annotated.GET;
import org.eclipse.kapua.kura.simulator.app.annotated.POST;
import org.eclipse.kapua.kura.simulator.app.annotated.PUT;
import org.eclipse.kapua.kura.simulator.app.annotated.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotatedApplication
extends AbstractDefaultApplication {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedApplication.class);
    private final Map<String, ResourceHandler> handlers;

    private AnnotatedApplication(String applicationId, Map<String, ResourceHandler> handlers) {
        super(applicationId);
        this.handlers = handlers;
    }

    @Override
    protected void processRequest(Request request) throws Exception {
        String comand = request.getMessage().getTopic().render(0, 2);
        ResourceHandler handler = this.handlers.get(comand);
        logger.debug("Mapping request - {} -> {}", (Object)comand, (Object)handler);
        if (handler == null) {
            request.replyNotFound();
            return;
        }
        handler.handle(request);
    }

    public static org.eclipse.kapua.kura.simulator.app.Application build(Object applicationInstance) throws Exception {
        Objects.requireNonNull(applicationInstance);
        Class<?> clazz = applicationInstance.getClass();
        Application app = clazz.getAnnotation(Application.class);
        if (app == null) {
            throw new IllegalArgumentException(String.format("Application class %s is missing the @%s annotation", clazz.getName(), Application.class.getName()));
        }
        String appId = app.value();
        if (appId == null || appId.isEmpty()) {
            throw new IllegalArgumentException(String.format("Application annotation must have a valid application id value", new Object[0]));
        }
        HashMap<String, ResourceHandler> handlers = new HashMap<String, ResourceHandler>();
        AnnotatedApplication.fillHandlers(handlers, clazz, applicationInstance);
        return new AnnotatedApplication(appId, handlers);
    }

    public static org.eclipse.kapua.kura.simulator.app.Application build(Class<?> applicationClazz) throws Exception {
        try {
            return AnnotatedApplication.build(applicationClazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to create application instance", e);
        }
    }

    private static void fillHandlers(Map<String, ResourceHandler> handlers, Class<? extends Object> clazz, Object applicationInstance) throws Exception {
        for (Method method : clazz.getMethods()) {
            AnnotatedApplication.fillHandlersFromMethod(handlers, clazz, applicationInstance, method);
        }
    }

    private static void fillHandlersFromMethod(Map<String, ResourceHandler> handlers, Class<? extends Object> clazz, Object applicationInstance, Method method) throws Exception {
        Resource r = method.getAnnotation(Resource.class);
        if (r != null) {
            AnnotatedApplication.fillHandlersFromResourceMethod(handlers, clazz, applicationInstance, method);
        }
        AnnotatedApplication.fillHandlersFromVerbMethod(handlers, clazz, applicationInstance, method, EXECUTE.class, "EXEC");
        AnnotatedApplication.fillHandlersFromVerbMethod(handlers, clazz, applicationInstance, method, GET.class, "GET");
        AnnotatedApplication.fillHandlersFromVerbMethod(handlers, clazz, applicationInstance, method, PUT.class, "PUT");
        AnnotatedApplication.fillHandlersFromVerbMethod(handlers, clazz, applicationInstance, method, POST.class, "POST");
        AnnotatedApplication.fillHandlersFromVerbMethod(handlers, clazz, applicationInstance, method, DELETE.class, "DEL");
    }

    private static void fillHandlersFromVerbMethod(Map<String, ResourceHandler> handlers, Class<?> clazz, Object applicationInstance, Method method, Class<? extends Annotation> annotationClazz, String kuraVerb) throws IllegalAccessException {
        if (!method.isAnnotationPresent(annotationClazz)) {
            return;
        }
        AnnotatedApplication.mapMethod(handlers, applicationInstance, method, kuraVerb, method.getName());
    }

    private static void fillHandlersFromResourceMethod(Map<String, ResourceHandler> handlers, Class<? extends Object> clazz, Object applicationInstance, Method method) throws Exception {
        String name = method.getName();
        String verb = null;
        StringBuilder verbBuilder = new StringBuilder();
        StringBuilder resourceBuilder = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (verbBuilder != null) {
                if (Character.isUpperCase(c)) {
                    verb = verbBuilder.toString().toUpperCase();
                    resourceBuilder.append(Character.toLowerCase(c));
                    verbBuilder = null;
                    continue;
                }
                verbBuilder.append(c);
                continue;
            }
            resourceBuilder.append(c);
        }
        String resource = resourceBuilder.toString();
        if (verb == null || verb.isEmpty() || resource == null || resource.isEmpty()) {
            throw new IllegalStateException(String.format("Method '%s' of class '%s' has not a valid name", name, clazz.getName()));
        }
        AnnotatedApplication.mapMethod(handlers, applicationInstance, method, verb, resource);
    }

    private static void mapMethod(Map<String, ResourceHandler> handlers, Object applicationInstance, Method method, String verb, String resource) throws IllegalAccessException {
        if ("DELETE".equals(verb)) {
            verb = "DEL";
        } else if ("EXECUTE".equals(verb)) {
            verb = "EXEC";
        }
        logger.debug("Mapping - {} - {}/{}", method.getDeclaringClass().getName(), verb, resource);
        MethodHandle mh = MethodHandles.lookup().unreflect(method);
        handlers.put(verb + "/" + resource, new PlainMethodHandler(mh.bindTo(applicationInstance)));
    }

    private static class PlainMethodHandler
    implements ResourceHandler {
        private final MethodHandle methodHandle;

        public PlainMethodHandler(MethodHandle methodHandle) {
            this.methodHandle = methodHandle;
        }

        @Override
        public void handle(Request request) throws Exception {
            try {
                this.methodHandle.invokeExact(request);
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    private static interface ResourceHandler {
        public void handle(Request var1) throws Exception;
    }
}

