/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator.app;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.kapua.kura.simulator.Module;
import org.eclipse.kapua.kura.simulator.Transport;
import org.eclipse.kapua.kura.simulator.app.Application;
import org.eclipse.kapua.kura.simulator.app.ApplicationContext;
import org.eclipse.kapua.kura.simulator.app.Descriptor;
import org.eclipse.kapua.kura.simulator.app.Handler;
import org.eclipse.kapua.kura.simulator.payload.Message;
import org.eclipse.kapua.kura.simulator.topic.Topic;

public class ApplicationController
implements Module {
    private final Map<String, Entry> applications = new HashMap<String, Entry>();
    private final Transport transport;

    public ApplicationController(Transport transport) {
        this.transport = transport;
    }

    public ApplicationController(Transport transport, Collection<Application> applications) {
        this.transport = transport;
        applications.forEach(this::add);
    }

    public void add(Application application) {
        Descriptor desc = application.getDescriptor();
        final String id = desc.getId();
        this.remove(application);
        ApplicationContext context = new ApplicationContext(){

            @Override
            public void sendMessage(Topic topic, byte[] payload) {
                topic.attach("application-id", id);
                ApplicationController.this.transport.sendMessage(topic, payload);
            }
        };
        Handler handler = application.createHandler(context);
        Entry entry = new Entry(id, context, handler);
        this.applications.put(id, entry);
        this.subscribeEntry(entry);
    }

    public void remove(Application application) {
        String id = application.getDescriptor().getId();
        Entry entry = this.applications.remove(id);
        if (entry == null) {
            return;
        }
        this.transport.unsubscribe(Topic.application(id).append(Topic.Segment.wildcard()));
    }

    private void subscribeEntry(Entry entry) {
        this.transport.subscribe(Topic.application(entry.getId()).append(Topic.Segment.wildcard()), msg -> {
            Message message = msg.localize(Topic.application(entry.getId()));
            if (message != null) {
                entry.getHandler().processMessage(message);
            }
        });
    }

    @Override
    public void connected(Transport transport) {
        for (Entry entry : this.applications.values()) {
            entry.getHandler().connected();
            this.subscribeEntry(entry);
        }
    }

    @Override
    public void disconnected(Transport transport) {
        for (Entry entry : this.applications.values()) {
            entry.getHandler().disconnected();
        }
    }

    public Set<String> getApplicationIds() {
        return Collections.unmodifiableSet(this.applications.keySet());
    }

    private static class Entry {
        private final String id;
        private final Handler handler;

        public Entry(String id, ApplicationContext context, Handler handler) {
            this.id = id;
            this.handler = handler;
        }

        public String getId() {
            return this.id;
        }

        public Handler getHandler() {
            return this.handler;
        }
    }
}

