/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator.app;

import org.eclipse.kapua.kura.simulator.app.Application;
import org.eclipse.kapua.kura.simulator.app.ApplicationContext;
import org.eclipse.kapua.kura.simulator.app.Descriptor;
import org.eclipse.kapua.kura.simulator.app.Handler;
import org.eclipse.kapua.kura.simulator.app.Request;
import org.eclipse.kapua.kura.simulator.payload.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDefaultApplication
implements Application {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDefaultApplication.class);
    private final Descriptor descriptor;

    protected abstract void processRequest(Request var1) throws Exception;

    public AbstractDefaultApplication(String applicationId) {
        this.descriptor = new Descriptor(applicationId);
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Handler createHandler(final ApplicationContext context) {
        return new Handler(){

            @Override
            public void processMessage(Message message) {
                AbstractDefaultApplication.this.process(context, message);
            }
        };
    }

    protected void process(ApplicationContext context, Message message) {
        Request request;
        logger.debug("Received message: {}", (Object)message);
        try {
            request = Request.parse(context, message);
        }
        catch (Exception e) {
            logger.warn("Failed to parse request message", e);
            return;
        }
        logger.debug("Processing request: {}", (Object)request);
        try {
            this.processRequest(request);
        }
        catch (Exception e) {
            logger.info("Failed to process request", e);
            request.replyError(e);
        }
    }
}

