/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator.topic;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Topic {
    private static final Segment CONTROL = new Segment(){

        @Override
        public String render(Function<String, String> replaceMapper) {
            return "$EDC";
        }

        public String toString() {
            return this.render(null);
        }
    };
    private static final Segment WILDCARD = new Segment(){

        @Override
        public String render(Function<String, String> replaceMapper) {
            return "#";
        }

        public String toString() {
            return this.render(null);
        }
    };
    private final List<Segment> segments;
    private final Map<String, String> context = new HashMap<String, String>();

    private Topic(List<Segment> segments) {
        this.segments = segments;
    }

    private Topic(Segment ... segments) {
        this.segments = Arrays.asList(segments);
    }

    public List<Segment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public String renderSegment(Segment segment, Map<String, String> context) {
        return segment.render((Function<String, String>)((Function)key -> {
            if (context.containsKey(key)) {
                return (String)context.get(key);
            }
            return this.context.get(key);
        }));
    }

    public String render(Map<String, String> context) {
        return this.renderInternal(this.segments, context);
    }

    public String render(int fromIndex, int toIndex, Map<String, String> context) {
        return this.renderInternal(this.segments.subList(fromIndex, toIndex), context);
    }

    public String render() {
        return this.renderInternal(this.segments, Collections.emptyMap());
    }

    public String render(int fromIndex, int toIndex) {
        return this.renderInternal(this.segments.subList(fromIndex, toIndex), Collections.emptyMap());
    }

    private String renderInternal(List<Segment> segments, Map<String, String> context) {
        return segments.stream().map(seg -> this.renderSegment((Segment)seg, context)).collect(Collectors.joining("/"));
    }

    public static Topic from(List<Segment> segments) {
        Objects.requireNonNull(segments);
        return new Topic(segments);
    }

    public static Topic fromString(String topic) {
        return Topic.from(Arrays.stream(topic.split("\\/")).map(Segment::plain).collect(Collectors.toList()));
    }

    public static Topic reply(String requesterClientId, String requestId) {
        return new Topic(Segment.control(), Segment.account(), Segment.plain(requesterClientId), Segment.replace("application-id"), Segment.plain("REPLY"), Segment.plain(requestId));
    }

    public static Topic notify(String requesterClientId, String ... resource) {
        LinkedList<Segment> s = new LinkedList<Segment>();
        s.add(Segment.control());
        s.add(Segment.account());
        s.add(Segment.plain(requesterClientId));
        s.add(Segment.replace("application-id"));
        s.add(Segment.plain("NOTIFY"));
        s.addAll(Segment.plain(resource));
        return new Topic(s);
    }

    public static Topic application(String application) {
        return new Topic(Segment.control(), Segment.account(), Segment.clientId(), Segment.plain(application));
    }

    public static Topic device(String localTopic) {
        return new Topic(Segment.control(), Segment.account(), Segment.clientId(), Segment.raw(localTopic));
    }

    public Topic append(Segment segment) {
        ArrayList<Segment> segs = new ArrayList<Segment>(this.segments.size() + 1);
        segs.addAll(this.segments);
        segs.add(segment);
        return new Topic(segs);
    }

    public Topic attach(String key, String value) {
        this.context.put(key, value);
        return this;
    }

    public Topic attachAll(Map<String, String> topicContext) {
        this.context.putAll(topicContext);
        return this;
    }

    public Topic localize(Topic otherTopic) {
        return this.localize(otherTopic, Collections.emptyMap());
    }

    public Topic localize(Topic otherTopic, Map<String, String> topicContext) {
        LinkedList<Segment> newTopic = new LinkedList<Segment>(this.getSegments());
        for (Segment seg : otherTopic.getSegments()) {
            String segValue2;
            String segValue1 = this.renderSegment(newTopic.removeFirst(), topicContext);
            if (segValue1.equals(segValue2 = otherTopic.renderSegment(seg, topicContext))) continue;
            return null;
        }
        return Topic.from(newTopic);
    }

    public String toString() {
        return this.segments.stream().map(Object::toString).collect(Collectors.joining("/"));
    }

    public Map<String, String> getContext() {
        return Collections.unmodifiableMap(this.context);
    }

    private static class ReplaceSegment
    implements Segment {
        private final String key;

        public ReplaceSegment(String key) {
            this.key = key;
        }

        @Override
        public String render(Function<String, String> replaceMapper) {
            String value = (String)replaceMapper.apply((Object)this.key);
            if (value == null || value.isEmpty()) {
                throw new IllegalStateException(String.format("Unable to replace segment '%s', no value found", this.key));
            }
            return value;
        }

        public String toString() {
            return "<" + this.key + ">";
        }
    }

    public static interface Segment {
        public String render(Function<String, String> var1);

        default public String render() {
            return this.render((Function<String, String>)((Function)key -> null));
        }

        public static Segment control() {
            return CONTROL;
        }

        public static Segment wildcard() {
            return WILDCARD;
        }

        public static Segment plain(String segment) {
            Objects.requireNonNull(segment);
            if (segment.isEmpty() || segment.contains("/")) {
                throw new IllegalArgumentException(String.format("Illegal argument: '%s'", segment));
            }
            return Segment.raw(segment);
        }

        public static List<Segment> plain(String ... segment) {
            Objects.requireNonNull(segment);
            return Arrays.stream(segment).map(Segment::plain).collect(Collectors.toList());
        }

        public static Segment raw(final String raw) {
            Objects.requireNonNull(raw);
            return new Segment(){

                @Override
                public String render(Function<String, String> replaceMapper) {
                    return raw;
                }

                public String toString() {
                    return this.render(null);
                }
            };
        }

        public static Segment replace(String key) {
            return new ReplaceSegment(key);
        }

        public static Segment account() {
            return Segment.replace("account-name");
        }

        public static Segment clientId() {
            return Segment.replace("client-id");
        }
    }
}

