/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator.main;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.eclipse.kapua.kura.simulator.GatewayConfiguration;
import org.eclipse.kapua.kura.simulator.MqttSimulatorTransport;
import org.eclipse.kapua.kura.simulator.Simulator;
import org.eclipse.kapua.kura.simulator.app.Application;
import org.eclipse.kapua.kura.simulator.app.annotated.AnnotatedApplication;
import org.eclipse.kapua.kura.simulator.app.command.SimpleCommandApplication;
import org.eclipse.kapua.kura.simulator.app.deploy.SimpleDeployApplication;
import org.eclipse.kapua.kura.simulator.util.NameThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class SimulatorRunner {
    private static final Logger logger = LoggerFactory.getLogger(SimulatorRunner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        SimulatorRunner.toInfinityAndBeyond();
        Options opts = new Options();
        opts.addOption("n", "basename", true, "The base name of the simulator instance");
        opts.addOption("c", "count", true, "The number of instances to start");
        opts.addOption("b", "broker", true, "The URL to the broker");
        opts.addOption("a", "account-name", true, "The name of the account");
        opts.addOption("s", "shutdown", true, "Shutdown simulator after x seconds");
        CommandLine cli = new DefaultParser().parse(opts, args);
        String basename = cli.getOptionValue('n', SimulatorRunner.env("KSIM_BASE_NAME", "sim-"));
        int count = Integer.parseInt(cli.getOptionValue('c', SimulatorRunner.env("KSIM_NUM_GATEWAYS", "1")));
        String broker = cli.getOptionValue('b', SimulatorRunner.createBrokerUrl());
        String accountName = cli.getOptionValue('a', SimulatorRunner.env("KSIM_ACCOUNT_NAME", "kapua-sys"));
        long shutdownAfter = Long.parseLong(cli.getOptionValue('s', Long.toString(9223372036854775L)));
        SimulatorRunner.dumpEnv();
        logger.info("Starting simulation ...");
        logger.info("\tbasename : {}", (Object)basename);
        logger.info("\tcount: {}", (Object)count);
        logger.info("\tbroker: {}", (Object)broker);
        logger.info("\taccount-name: {}", (Object)accountName);
        ScheduledExecutorService downloadExecutor = Executors.newSingleThreadScheduledExecutor(new NameThreadFactory("DownloadSimulator"));
        LinkedList<AutoCloseable> close = new LinkedList<AutoCloseable>();
        try {
            for (int i = 1; i <= count; ++i) {
                String name = String.format("%s%s", basename, i);
                GatewayConfiguration configuration = new GatewayConfiguration(broker, accountName, name);
                HashSet<Application> apps = new HashSet<Application>();
                apps.add(new SimpleCommandApplication(s -> String.format("Command '%s' not found", s)));
                apps.add(AnnotatedApplication.build(new SimpleDeployApplication(downloadExecutor)));
                MqttSimulatorTransport transport = new MqttSimulatorTransport(configuration);
                close.add(transport);
                Simulator simulator = new Simulator(configuration, transport, apps);
                close.add(simulator);
            }
            Thread.sleep(shutdownAfter * 1000L);
            logger.info("Bye bye...");
        }
        finally {
            downloadExecutor.shutdown();
            SimulatorRunner.closeAll(close);
        }
        logger.info("Exiting...");
    }

    private static void dumpEnv() {
        List keys = System.getenv().keySet().stream().filter(key -> key.startsWith("KSIM_")).sorted().collect(Collectors.toList());
        if (keys.isEmpty()) {
            logger.info("No KSIM_* env vars found");
            return;
        }
        logger.info("Dumping KSIM_* env vars:");
        for (String key2 : keys) {
            logger.info("\t{} = '{}'", (Object)key2, (Object)System.getenv(key2));
        }
    }

    private static String createBrokerUrl() {
        String broker = System.getenv("KSIM_BROKER_URL");
        if (broker != null && !broker.isEmpty()) {
            return broker;
        }
        String proto = SimulatorRunner.env("KSIM_BROKER_PROTO", "tcp");
        String user = SimulatorRunner.env("KSIM_BROKER_USER", "kapua-broker");
        String password = SimulatorRunner.env("KSIM_BROKER_PASSWORD", "kapua-password");
        String host = SimulatorRunner.env("KSIM_BROKER_HOST", "localhost");
        String port = SimulatorRunner.env("KSIM_BROKER_PORT", "1883");
        StringBuilder sb = new StringBuilder(128);
        sb.append(proto).append("://");
        if (user != null && !user.isEmpty()) {
            sb.append(user);
            if (password != null && !password.isEmpty()) {
                sb.append(':').append(password);
            }
            sb.append('@');
        }
        sb.append(host).append(':').append(port);
        return sb.toString();
    }

    private static String env(String envName, String defaultValue) {
        return System.getenv().getOrDefault(envName, defaultValue);
    }

    private static void closeAll(List<AutoCloseable> close) throws Throwable {
        LinkedList<Exception> errors = new LinkedList<Exception>();
        for (AutoCloseable c : close) {
            try {
                c.close();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        Throwable e = (Throwable)errors.pollFirst();
        if (e != null) {
            errors.forEach(e::addSuppressed);
            throw e;
        }
    }

    private static void toInfinityAndBeyond() {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        java.util.logging.Logger.getLogger("org.eclipse.paho.client.mqttv3").setLevel(Level.ALL);
    }
}

