/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator.birth;

import com.google.common.io.BaseEncoding;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.time.Duration;
import java.time.Instant;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.kapua.kura.simulator.GatewayConfiguration;

public class BirthCertificateBuilder {
    private final GatewayConfiguration configuration;
    private final Instant started;
    private final Supplier<Set<String>> applicationIds;

    public BirthCertificateBuilder(GatewayConfiguration configuration, Instant started, Supplier<Set<String>> applicationIds) {
        this.configuration = configuration;
        this.started = started;
        this.applicationIds = applicationIds;
    }

    protected static void fillInConnectionInformation(Map<String, Object> metrics) {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            if (nis == null) {
                return;
            }
            LinkedList<String> interfaces = new LinkedList<String>();
            LinkedList<String> addresses = new LinkedList<String>();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (ni == null) continue;
                Iterator<InterfaceAddress> iterator = ni.getInterfaceAddresses().iterator();
                if (iterator.hasNext()) {
                    InterfaceAddress addr = iterator.next();
                    String hostAddress = addr.getAddress().getHostAddress();
                    hostAddress = hostAddress.replaceAll("%.*$", "");
                    addresses.add(hostAddress);
                    String name = ni.getName();
                    String hwAddr = BaseEncoding.base16().upperCase().withSeparator(":", 2).encode(ni.getHardwareAddress());
                    interfaces.add(String.format("%s (%s)", name, hwAddr));
                }
                metrics.put("connection_interface", String.join((CharSequence)",", interfaces));
                metrics.put("connection_ip", String.join((CharSequence)",", addresses));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Map<String, Object> build() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String id = this.configuration.getClientId();
        result.put("uptime", Long.toString(Duration.between(this.started, Instant.now()).toMillis()));
        result.put("display_name", "Kura Simulator (Display Name)");
        result.put("model_name", "Kura Simulator (Model Name)");
        result.put("model_id", "kura-simulator-" + id);
        result.put("part_number", "ksim-part-123456-" + id);
        result.put("serial_number", "ksim-serial-123456-" + id);
        result.put("available_processors", "1");
        result.put("total_memory", "640");
        result.put("firmware_version", "fw.v42");
        result.put("bios_version", "bios.v42");
        result.put("os", "Kura Simulator (OS)");
        result.put("os_version", "ksim-os-v42");
        result.put("os_arch", "ksim-arch");
        result.put("jvm_name", "Kura Simulator (Java)");
        result.put("jvm_version", "ksim-java-v42");
        result.put("jvm_profile", "Kura Simulator (Java Profile)");
        result.put("kura_version", "ksim-kura-v42");
        result.put("osgi_framework", "Kura Simulator (OSGi version)");
        result.put("osgi_framework_version", "ksim-osgi-v42");
        BirthCertificateBuilder.fillInConnectionInformation(result);
        result.put("application_ids", String.join((CharSequence)",", (Iterable<? extends CharSequence>)this.applicationIds.get()));
        return result;
    }
}

