/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator.app.deploy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.kapua.kura.simulator.app.Request;
import org.eclipse.kapua.kura.simulator.app.annotated.Application;
import org.eclipse.kapua.kura.simulator.app.annotated.Resource;
import org.eclipse.kapua.kura.simulator.app.deploy.BundleInformation;
import org.eclipse.kapua.kura.simulator.app.deploy.DeploymentDownloadPackageRequest;
import org.eclipse.kapua.kura.simulator.app.deploy.DeploymentInstallPackageRequest;
import org.eclipse.kapua.kura.simulator.app.deploy.DeploymentPackageInformation;
import org.eclipse.kapua.kura.simulator.app.deploy.DeploymentUninstallPackageRequest;
import org.eclipse.kapua.kura.simulator.app.deploy.DownloadState;
import org.eclipse.kapua.kura.simulator.app.deploy.InstallState;
import org.eclipse.kapua.kura.simulator.payload.Metrics;
import org.eclipse.kapua.kura.simulator.util.Documents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Application(value="DEPLOY-V2")
public abstract class AbstractDeployApplication {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDeployApplication.class);

    @Resource
    public void getBundles(Request request) throws Exception {
        List<BundleInformation> bundles = this.getBundles();
        request.replySuccess().send(this.bundlesToXml(bundles));
    }

    @Resource
    public void executeStart(Request request) {
        this.executeOnBundle(request, this::startBundle);
    }

    @Resource
    public void executeStop(Request request) {
        this.executeOnBundle(request, this::stopBundle);
    }

    @Resource
    public void getPackages(Request request) throws Exception {
        List<DeploymentPackageInformation> packages = this.getPackages();
        request.replySuccess().send(this.packagesToXml(packages));
    }

    @Resource
    public void getInstall(Request request) {
        InstallState state = this.getInstallState().orElse(InstallState.IDLE);
        request.replySuccess().send(AbstractDeployApplication.toMetrics(state));
    }

    @Resource
    public void getDownload(Request request) {
        DownloadState state = this.getDownloadState().orElse(DownloadState.DONE);
        request.replySuccess().send(AbstractDeployApplication.toMetrics(state));
    }

    public static Map<String, Object> toMetrics(DownloadState state) {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("dp.download.size", state.getTransferSize());
        metrics.put("dp.download.progress", state.getTransferProgress());
        metrics.put("dp.download.status", state.getStatus());
        metrics.put("job.id", state.getJobId());
        return metrics;
    }

    public static Map<String, Object> toMetrics(InstallState state) {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("dp.name", state.getName());
        metrics.put("dp.version", state.getVersion());
        metrics.put("dp.install.status", state.getStatus());
        metrics.put("dp.install.progress", state.getProgress());
        metrics.put("job.id", state.getJobId());
        return metrics;
    }

    @Resource
    public void executeInstall(Request request) {
        logger.debug("executeInstall");
        DeploymentInstallPackageRequest installRequest = Metrics.readFrom(new DeploymentInstallPackageRequest(), request.getMetrics());
        this.executeInstall(request, installRequest);
        request.replySuccess().send();
    }

    @Resource
    public void executeUninstall(Request request) {
        logger.debug("executeUninstall");
        DeploymentUninstallPackageRequest uninstallRequest = Metrics.readFrom(new DeploymentUninstallPackageRequest(), request.getMetrics());
        this.executeUninstall(request, uninstallRequest);
    }

    @Resource
    public void executeDownload(Request request) {
        logger.debug("executeDownload");
        DeploymentDownloadPackageRequest downloadRequest = Metrics.readFrom(new DeploymentDownloadPackageRequest(), request.getMetrics());
        this.executeDownload(request, downloadRequest);
    }

    @Resource
    public void deleteDownload(Request request) {
        this.cancelDownload(request);
    }

    protected abstract boolean startBundle(long var1);

    protected abstract boolean stopBundle(long var1);

    protected abstract List<BundleInformation> getBundles();

    protected abstract List<DeploymentPackageInformation> getPackages();

    protected abstract void executeDownload(Request var1, DeploymentDownloadPackageRequest var2);

    protected abstract void executeInstall(Request var1, DeploymentInstallPackageRequest var2);

    protected abstract void executeUninstall(Request var1, DeploymentUninstallPackageRequest var2);

    protected abstract Optional<DownloadState> getDownloadState();

    protected abstract Optional<InstallState> getInstallState();

    protected abstract void cancelDownload(Request var1);

    public void executeOnBundle(Request request, Function<Long, Boolean> consumer) {
        long bundleId = Long.parseLong(request.renderTopic(2));
        if (consumer.apply(bundleId).booleanValue()) {
            request.replySuccess().send();
        } else {
            request.replyNotFound();
        }
    }

    protected String packagesToXml(List<DeploymentPackageInformation> packages) throws Exception {
        return Documents.create(doc -> this.fillPackagesDocument((Document)doc, packages));
    }

    protected void fillPackagesDocument(Document doc, List<DeploymentPackageInformation> packages) {
        Element ps = doc.createElement("packages");
        doc.appendChild(ps);
        for (DeploymentPackageInformation dp : packages) {
            Element p = doc.createElement("package");
            ps.appendChild(p);
            AbstractDeployApplication.addValue(p, "name", dp.getSymbolicName());
            AbstractDeployApplication.addValue(p, "version", dp.getVersion());
            Element bs = doc.createElement("bundles");
            p.appendChild(bs);
            for (DeploymentPackageInformation.BundleInformation bi : dp.getBundles()) {
                Element b = doc.createElement("bundle");
                bs.appendChild(b);
                AbstractDeployApplication.addValue(b, "name", bi.getSymbolicName());
                AbstractDeployApplication.addValue(b, "version", bi.getVersion());
            }
        }
    }

    protected String bundlesToXml(List<BundleInformation> bundles) throws Exception {
        return Documents.create(doc -> this.fillBundlesDocument((Document)doc, bundles));
    }

    protected void fillBundlesDocument(Document doc, List<BundleInformation> bundles) {
        Element bs = doc.createElement("bundles");
        doc.appendChild(bs);
        for (BundleInformation bi : bundles) {
            Element b = doc.createElement("bundle");
            bs.appendChild(b);
            AbstractDeployApplication.addValue(b, "name", bi.getSymbolicName());
            AbstractDeployApplication.addValue(b, "version", bi.getVersion());
            AbstractDeployApplication.addValue(b, "id", Long.toString(bi.getId()));
            AbstractDeployApplication.addValue(b, "state", bi.getStateString());
        }
    }

    protected static void addValue(Element b, String name, String value) {
        Element ele = b.getOwnerDocument().createElement(name);
        b.appendChild(ele);
        ele.setTextContent(value);
    }
}

