/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator.app;

import com.google.protobuf.ByteString;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.eclipse.kapua.kura.simulator.Transport;
import org.eclipse.kapua.kura.simulator.payload.Metrics;
import org.eclipse.kapua.kura.simulator.topic.Topic;
import org.eclipse.kura.core.message.protobuf.KuraPayloadProto;

public abstract class Sender {
    protected abstract void send(KuraPayloadProto.KuraPayload.Builder var1);

    public void send(byte[] body) {
        this.send(Collections.emptyMap(), body);
    }

    public void send(String body) {
        this.send(Collections.emptyMap(), body.getBytes(StandardCharsets.UTF_8));
    }

    public void send(String body, Charset charset) {
        this.send(Collections.emptyMap(), body.getBytes(charset));
    }

    public void send(Map<String, Object> metrics) {
        this.send(metrics, null);
    }

    public void send() {
        this.send((Map<String, Object>)null, (byte[])null);
    }

    public void send(Map<String, Object> metrics, byte[] body) {
        KuraPayloadProto.KuraPayload.Builder payload = KuraPayloadProto.KuraPayload.newBuilder();
        if (metrics != null) {
            Metrics.buildMetrics(payload, metrics);
        }
        if (body != null) {
            payload.setBody(ByteString.copyFrom((byte[])body));
        }
        this.send(payload);
    }

    public static Sender transportSender(final Topic topic, final Transport transport) {
        return new Sender(){

            @Override
            protected void send(KuraPayloadProto.KuraPayload.Builder payload) {
                transport.sendMessage(topic, payload.build().toByteArray());
            }
        };
    }
}

