/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator.app;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.kapua.kura.simulator.app.ApplicationContext;
import org.eclipse.kapua.kura.simulator.app.Sender;
import org.eclipse.kapua.kura.simulator.payload.Message;
import org.eclipse.kapua.kura.simulator.payload.Metrics;
import org.eclipse.kapua.kura.simulator.topic.Topic;
import org.eclipse.kura.core.message.protobuf.KuraPayloadProto;

public class Request {
    private static final String NL = System.lineSeparator();
    private final ApplicationContext applicationContext;
    private final Message message;
    private final Map<String, Object> metrics;
    private final String requestId;
    private final String requesterClientId;

    public Request(ApplicationContext applicationContext, Message message, Map<String, Object> metrics, String requestId, String requesterClientId) {
        Objects.requireNonNull(applicationContext);
        Objects.requireNonNull(message);
        Objects.requireNonNull(metrics);
        Objects.requireNonNull(requestId);
        Objects.requireNonNull(requesterClientId);
        this.applicationContext = applicationContext;
        this.message = message;
        this.metrics = metrics;
        this.requestId = requestId;
        this.requesterClientId = requesterClientId;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Message getMessage() {
        return this.message;
    }

    public Map<String, Object> getMetrics() {
        return Collections.unmodifiableMap(this.metrics);
    }

    public String getRequesterClientId() {
        return this.requesterClientId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String renderTopic(int index) {
        return this.message.getTopic().render(index, index + 1);
    }

    public String renderTopic(int fromIndex, int toIndex) {
        return this.message.getTopic().render(fromIndex, toIndex);
    }

    public static Request parse(ApplicationContext context, Message message) throws Exception {
        KuraPayloadProto.KuraPayload payload = KuraPayloadProto.KuraPayload.parseFrom(message.getPayload());
        Map<String, Object> metrics = Metrics.extractMetrics(payload);
        String requestId = Metrics.getAsString(metrics, "request.id");
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID (request.id) missing in message");
        }
        String requesterClientId = Metrics.getAsString(metrics, "requester.client.id");
        if (requesterClientId == null) {
            throw new IllegalArgumentException("Requester Client ID (requester.client.id) missing in message");
        }
        return new Request(context, message, metrics, requestId, requesterClientId);
    }

    public Sender replySuccess() {
        return this.reply(200);
    }

    public Sender replyError() {
        return this.reply(500);
    }

    public Sender reply(final int responseCode) {
        return new Sender(){

            @Override
            protected void send(KuraPayloadProto.KuraPayload.Builder payload) {
                for (KuraPayloadProto.KuraPayload.KuraMetricOrBuilder kuraMetricOrBuilder : payload.getMetricOrBuilderList()) {
                    if (!kuraMetricOrBuilder.getName().equals("response.code")) continue;
                    throw new IllegalArgumentException(String.format("Metrics must not already contain '%s'", "response.code"));
                }
                Metrics.addMetric(payload, "response.code", responseCode);
                Request.this.applicationContext.sendMessage(Topic.reply(Request.this.requesterClientId, Request.this.requestId), payload.build().toByteArray());
            }
        };
    }

    public Sender notification(final String resource) {
        return new Sender(){

            @Override
            protected void send(KuraPayloadProto.KuraPayload.Builder payload) {
                Request.this.applicationContext.sendMessage(Topic.notify(Request.this.requesterClientId, resource), payload.build().toByteArray());
            }
        };
    }

    public void replyError(Throwable error) {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        if (error != null) {
            metrics.put("response.exception.message", ExceptionUtils.getRootCauseMessage((Throwable)error));
            metrics.put("response.exception.stack", ExceptionUtils.getStackTrace((Throwable)error));
        }
        this.reply(500).send(metrics);
    }

    public void replyNotFound() {
        this.reply(404).send(Collections.emptyMap());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Request - ").append(this.message.getTopic());
        if (!this.metrics.isEmpty()) {
            sb.append(NL);
        }
        for (Map.Entry<String, Object> entry : this.metrics.entrySet()) {
            Object value = entry.getValue();
            sb.append("\t");
            sb.append(entry.getKey()).append(" => ");
            if (value != null) {
                sb.append(value.getClass().getSimpleName()).append(" : ").append(value);
            } else {
                sb.append("null");
            }
            sb.append(NL);
        }
        sb.append("]");
        return sb.toString();
    }
}

