/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.kura.simulator;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.kapua.kura.simulator.GatewayConfiguration;
import org.eclipse.kapua.kura.simulator.Module;
import org.eclipse.kapua.kura.simulator.Transport;
import org.eclipse.kapua.kura.simulator.app.Application;
import org.eclipse.kapua.kura.simulator.app.ApplicationController;
import org.eclipse.kapua.kura.simulator.birth.BirthCertificateModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Simulator
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Simulator.class);
    protected final Transport transport;
    protected List<Module> modules = new LinkedList<Module>();

    public Simulator(GatewayConfiguration configuration, Transport transport, Set<Application> applications) {
        this.transport = transport;
        this.transport.whenConnected(this::connected);
        this.transport.whenDisconnected(this::disconnected);
        ApplicationController applicationController = new ApplicationController(transport, applications);
        this.modules.add(applicationController);
        this.modules.add(new BirthCertificateModule(configuration, applicationController::getApplicationIds));
        this.transport.connect();
    }

    @Override
    public void close() {
    }

    protected void connected() {
        logger.info("Connected ... sending birth certificate ...");
        for (Module module : this.modules) {
            try {
                module.connected(this.transport);
            }
            catch (Exception e) {
                logger.warn("Failed to call module: {}", (Object)module, (Object)e);
            }
        }
    }

    protected void disconnected() {
        for (Module module : this.modules) {
            try {
                module.disconnected(this.transport);
            }
            catch (Exception e) {
                logger.warn("Failed to call module: {}", (Object)module, (Object)e);
            }
        }
    }
}

