/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.tcp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequestHandler;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.server.config.UaTcpStackServerConfig;
import org.eclipse.milo.opcua.stack.server.tcp.UaTcpStackServer;

public class FallbackServer {
    private final Set<UaTcpStackServer> registered = Sets.newConcurrentHashSet();
    private final Map<String, UaTcpStackServer> servers = Maps.newConcurrentMap();
    private final UaTcpStackServer server;

    public FallbackServer() {
        UaTcpStackServerConfig config = UaTcpStackServerConfig.builder().setApplicationName(LocalizedText.english("Stack Discovery Server")).setApplicationUri("urn:eclipse:milo:opcua:stack:discovery").setProductUri("https://projects.eclipse.org/projects/iot.milo").build();
        this.server = new UaTcpStackServer(config);
        this.server.addRequestHandler(FindServersRequest.class, new FindServersHandler());
        this.server.addRequestHandler(GetEndpointsRequest.class, new GetEndpointsHandler());
    }

    public void registerServer(UaTcpStackServer server) {
        if (this.registered.add(server)) {
            server.getDiscoveryUrls().forEach(url -> this.servers.put((String)url, server));
        }
    }

    public void unregisterServer(UaTcpStackServer server) {
        if (this.registered.remove(server)) {
            server.getDiscoveryUrls().forEach(this.servers::remove);
        }
    }

    public UaTcpStackServer getServer() {
        return this.server;
    }

    private class FindServersHandler
    implements ServiceRequestHandler<FindServersRequest, FindServersResponse> {
        private FindServersHandler() {
        }

        @Override
        public void handle(ServiceRequest<FindServersRequest, FindServersResponse> service) throws UaException {
            FindServersRequest request = service.getRequest();
            ArrayList<ApplicationDescription> servers = new ArrayList<ApplicationDescription>();
            List<String> serverUris = ConversionUtil.l(request.getServerUris());
            for (UaTcpStackServer server : FallbackServer.this.registered) {
                ApplicationDescription description = server.getApplicationDescription();
                if (serverUris.isEmpty()) {
                    servers.add(description);
                    continue;
                }
                if (!serverUris.contains(description.getApplicationUri())) continue;
                servers.add(description);
            }
            ResponseHeader header = service.createResponseHeader();
            FindServersResponse response = new FindServersResponse(header, servers.toArray(new ApplicationDescription[servers.size()]));
            service.setResponse(response);
        }
    }

    private class GetEndpointsHandler
    implements ServiceRequestHandler<GetEndpointsRequest, GetEndpointsResponse> {
        private GetEndpointsHandler() {
        }

        @Override
        public void handle(ServiceRequest<GetEndpointsRequest, GetEndpointsResponse> service) throws UaException {
            UaTcpStackServer server;
            GetEndpointsRequest request = service.getRequest();
            String endpointUrl = request.getEndpointUrl();
            if (endpointUrl == null) {
                endpointUrl = "";
            }
            EndpointDescription[] endpoints = (server = (UaTcpStackServer)FallbackServer.this.servers.get(endpointUrl)) != null ? server.getEndpointDescriptions() : new EndpointDescription[]{};
            ArrayList profileUris = request.getProfileUris() != null ? Lists.newArrayList((Object[])request.getProfileUris()) : new ArrayList();
            EndpointDescription[] filtered = (EndpointDescription[])Arrays.stream(endpoints).filter(ed -> this.filterProfileUris((EndpointDescription)ed, profileUris)).filter(this::filterEndpointUrls).toArray(EndpointDescription[]::new);
            service.setResponse(new GetEndpointsResponse(service.createResponseHeader(), filtered));
        }

        private boolean filterProfileUris(EndpointDescription endpoint, List<String> profileUris) {
            return profileUris.size() == 0 || profileUris.contains(endpoint.getTransportProfileUri());
        }

        private boolean filterEndpointUrls(EndpointDescription endpoint) {
            return true;
        }
    }
}

