/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;

public class SignatureUtil {
    public static byte[] sign(SecurityAlgorithm securityAlgorithm, PrivateKey privateKey, ByteBuffer ... buffers) throws UaException {
        String transformation = securityAlgorithm.getTransformation();
        try {
            Signature signature = Signature.getInstance(transformation);
            signature.initSign(privateKey);
            for (ByteBuffer buffer : buffers) {
                signature.update(buffer);
            }
            return signature.sign();
        }
        catch (GeneralSecurityException e) {
            throw new UaException(0x80020000L, (Throwable)e);
        }
    }

    public static byte[] hmac(SecurityAlgorithm securityAlgorithm, byte[] secretKey, ByteBuffer ... buffers) throws UaException {
        String transformation = securityAlgorithm.getTransformation();
        try {
            Mac mac = Mac.getInstance(transformation);
            mac.init(new SecretKeySpec(secretKey, transformation));
            for (ByteBuffer buffer : buffers) {
                mac.update(buffer);
            }
            return mac.doFinal();
        }
        catch (GeneralSecurityException e) {
            throw new UaException(2148728832L, (Throwable)e);
        }
    }
}

