/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class FutureUtils {
    public static <T> CompletableFuture<List<T>> sequence(Stream<CompletableFuture<T>> stream) {
        return FutureUtils.sequence(stream.collect(Collectors.toList()));
    }

    public static <T> CompletableFuture<List<T>> sequence(List<CompletableFuture<T>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture[] fa = futures.toArray(new CompletableFuture[futures.size()]);
        return CompletableFuture.allOf(fa).thenApply(v -> {
            ArrayList results = new ArrayList(futures.size());
            for (CompletableFuture cf : futures) {
                results.add(cf.join());
            }
            return results;
        });
    }

    public static <T> CompletableFuture<List<T>> sequence(CompletableFuture<T>[] futures) {
        if (futures.length == 0) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.allOf(futures).thenApply(v -> {
            ArrayList results = new ArrayList(futures.length);
            for (CompletableFuture cf : futures) {
                results.add(cf.join());
            }
            return results;
        });
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable ex) {
        CompletableFuture f = new CompletableFuture();
        f.completeExceptionally(ex);
        return f;
    }

    public static <T> CompletableFuture<T> failedUaFuture(long statusCode) {
        return FutureUtils.failedUaFuture(new StatusCode(statusCode));
    }

    public static <T> CompletableFuture<T> failedUaFuture(StatusCode statusCode) {
        return FutureUtils.failedFuture(new UaException(statusCode));
    }

    public static <T> CompletableFuture<T> failedUaFuture(Throwable cause, long statusCode) {
        return FutureUtils.failedFuture(new UaException(statusCode, cause));
    }
}

