/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncSemaphore {
    private final ArrayDeque<CompletableFuture<SemaphorePermit>> waitQueue = new ArrayDeque();
    private final AtomicInteger availablePermits;

    public AsyncSemaphore(int initialPermits) {
        this.availablePermits = new AtomicInteger(initialPermits);
    }

    public synchronized CompletableFuture<SemaphorePermit> acquire() {
        CompletableFuture<SemaphorePermit> f = new CompletableFuture<SemaphorePermit>();
        if (this.availablePermits.get() > 0) {
            this.availablePermits.decrementAndGet();
            f.complete(new PermitImpl());
        } else {
            this.waitQueue.addLast(f);
        }
        return f;
    }

    private final class PermitImpl
    implements SemaphorePermit {
        private PermitImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            CompletableFuture next;
            AsyncSemaphore asyncSemaphore = AsyncSemaphore.this;
            synchronized (asyncSemaphore) {
                next = (CompletableFuture)AsyncSemaphore.this.waitQueue.pollFirst();
                if (next == null) {
                    AsyncSemaphore.this.availablePermits.incrementAndGet();
                }
            }
            if (next != null) {
                next.complete(new PermitImpl());
            }
        }
    }

    public static interface SemaphorePermit {
        public void release();
    }
}

