/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;

@UaDataType(value="WriteRequest")
public class WriteRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.WriteRequest;
    public static final NodeId BinaryEncodingId = Identifiers.WriteRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.WriteRequest_Encoding_DefaultXml;
    protected final RequestHeader _requestHeader;
    protected final WriteValue[] _nodesToWrite;

    public WriteRequest() {
        this._requestHeader = null;
        this._nodesToWrite = null;
    }

    public WriteRequest(RequestHeader _requestHeader, WriteValue[] _nodesToWrite) {
        this._requestHeader = _requestHeader;
        this._nodesToWrite = _nodesToWrite;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this._requestHeader;
    }

    @Nullable
    public WriteValue[] getNodesToWrite() {
        return this._nodesToWrite;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this._requestHeader).add("NodesToWrite", (Object)this._nodesToWrite).toString();
    }

    public static void encode(WriteRequest writeRequest, UaEncoder encoder) {
        encoder.encodeSerializable("RequestHeader", writeRequest._requestHeader != null ? writeRequest._requestHeader : new RequestHeader());
        encoder.encodeArray("NodesToWrite", writeRequest._nodesToWrite, encoder::encodeSerializable);
    }

    public static WriteRequest decode(UaDecoder decoder) {
        RequestHeader _requestHeader = decoder.decodeSerializable("RequestHeader", RequestHeader.class);
        WriteValue[] _nodesToWrite = decoder.decodeArray("NodesToWrite", decoder::decodeSerializable, WriteValue.class);
        return new WriteRequest(_requestHeader, _nodesToWrite);
    }

    static {
        DelegateRegistry.registerEncoder(WriteRequest::encode, WriteRequest.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(WriteRequest::decode, WriteRequest.class, BinaryEncodingId, XmlEncodingId);
    }
}

