/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;

@UaDataType(value="UserNameIdentityToken")
public class UserNameIdentityToken
extends UserIdentityToken {
    public static final NodeId TypeId = Identifiers.UserNameIdentityToken;
    public static final NodeId BinaryEncodingId = Identifiers.UserNameIdentityToken_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.UserNameIdentityToken_Encoding_DefaultXml;
    protected final String _userName;
    protected final ByteString _password;
    protected final String _encryptionAlgorithm;

    public UserNameIdentityToken() {
        super(null);
        this._userName = null;
        this._password = null;
        this._encryptionAlgorithm = null;
    }

    public UserNameIdentityToken(String _policyId, String _userName, ByteString _password, String _encryptionAlgorithm) {
        super(_policyId);
        this._userName = _userName;
        this._password = _password;
        this._encryptionAlgorithm = _encryptionAlgorithm;
    }

    public String getUserName() {
        return this._userName;
    }

    public ByteString getPassword() {
        return this._password;
    }

    public String getEncryptionAlgorithm() {
        return this._encryptionAlgorithm;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("PolicyId", (Object)this._policyId).add("UserName", (Object)this._userName).add("Password", (Object)this._password).add("EncryptionAlgorithm", (Object)this._encryptionAlgorithm).toString();
    }

    public static void encode(UserNameIdentityToken userNameIdentityToken, UaEncoder encoder) {
        encoder.encodeString("PolicyId", userNameIdentityToken._policyId);
        encoder.encodeString("UserName", userNameIdentityToken._userName);
        encoder.encodeByteString("Password", userNameIdentityToken._password);
        encoder.encodeString("EncryptionAlgorithm", userNameIdentityToken._encryptionAlgorithm);
    }

    public static UserNameIdentityToken decode(UaDecoder decoder) {
        String _policyId = decoder.decodeString("PolicyId");
        String _userName = decoder.decodeString("UserName");
        ByteString _password = decoder.decodeByteString("Password");
        String _encryptionAlgorithm = decoder.decodeString("EncryptionAlgorithm");
        return new UserNameIdentityToken(_policyId, _userName, _password, _encryptionAlgorithm);
    }

    static {
        DelegateRegistry.registerEncoder(UserNameIdentityToken::encode, UserNameIdentityToken.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(UserNameIdentityToken::decode, UserNameIdentityToken.class, BinaryEncodingId, XmlEncodingId);
    }
}

