/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.PerformUpdateType;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryEventFieldList;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;

@UaDataType(value="UpdateEventDetails")
public class UpdateEventDetails
extends HistoryUpdateDetails {
    public static final NodeId TypeId = Identifiers.UpdateEventDetails;
    public static final NodeId BinaryEncodingId = Identifiers.UpdateEventDetails_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.UpdateEventDetails_Encoding_DefaultXml;
    protected final PerformUpdateType _performInsertReplace;
    protected final EventFilter _filter;
    protected final HistoryEventFieldList[] _eventData;

    public UpdateEventDetails() {
        super(null);
        this._performInsertReplace = null;
        this._filter = null;
        this._eventData = null;
    }

    public UpdateEventDetails(NodeId _nodeId, PerformUpdateType _performInsertReplace, EventFilter _filter, HistoryEventFieldList[] _eventData) {
        super(_nodeId);
        this._performInsertReplace = _performInsertReplace;
        this._filter = _filter;
        this._eventData = _eventData;
    }

    public PerformUpdateType getPerformInsertReplace() {
        return this._performInsertReplace;
    }

    public EventFilter getFilter() {
        return this._filter;
    }

    @Nullable
    public HistoryEventFieldList[] getEventData() {
        return this._eventData;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("NodeId", (Object)this._nodeId).add("PerformInsertReplace", (Object)this._performInsertReplace).add("Filter", (Object)this._filter).add("EventData", (Object)this._eventData).toString();
    }

    public static void encode(UpdateEventDetails updateEventDetails, UaEncoder encoder) {
        encoder.encodeNodeId("NodeId", updateEventDetails._nodeId);
        encoder.encodeEnumeration("PerformInsertReplace", updateEventDetails._performInsertReplace);
        encoder.encodeSerializable("Filter", updateEventDetails._filter != null ? updateEventDetails._filter : new EventFilter());
        encoder.encodeArray("EventData", updateEventDetails._eventData, encoder::encodeSerializable);
    }

    public static UpdateEventDetails decode(UaDecoder decoder) {
        NodeId _nodeId = decoder.decodeNodeId("NodeId");
        PerformUpdateType _performInsertReplace = decoder.decodeEnumeration("PerformInsertReplace", PerformUpdateType.class);
        EventFilter _filter = decoder.decodeSerializable("Filter", EventFilter.class);
        HistoryEventFieldList[] _eventData = decoder.decodeArray("EventData", decoder::decodeSerializable, HistoryEventFieldList.class);
        return new UpdateEventDetails(_nodeId, _performInsertReplace, _filter, _eventData);
    }

    static {
        DelegateRegistry.registerEncoder(UpdateEventDetails::encode, UpdateEventDetails.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(UpdateEventDetails::decode, UpdateEventDetails.class, BinaryEncodingId, XmlEncodingId);
    }
}

