/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

@UaDataType(value="TimeZoneDataType")
public class TimeZoneDataType
implements UaStructure {
    public static final NodeId TypeId = Identifiers.TimeZoneDataType;
    public static final NodeId BinaryEncodingId = Identifiers.TimeZoneDataType_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.TimeZoneDataType_Encoding_DefaultXml;
    protected final Short _offset;
    protected final Boolean _daylightSavingInOffset;

    public TimeZoneDataType() {
        this._offset = null;
        this._daylightSavingInOffset = null;
    }

    public TimeZoneDataType(Short _offset, Boolean _daylightSavingInOffset) {
        this._offset = _offset;
        this._daylightSavingInOffset = _daylightSavingInOffset;
    }

    public Short getOffset() {
        return this._offset;
    }

    public Boolean getDaylightSavingInOffset() {
        return this._daylightSavingInOffset;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Offset", (Object)this._offset).add("DaylightSavingInOffset", (Object)this._daylightSavingInOffset).toString();
    }

    public static void encode(TimeZoneDataType timeZoneDataType, UaEncoder encoder) {
        encoder.encodeInt16("Offset", timeZoneDataType._offset);
        encoder.encodeBoolean("DaylightSavingInOffset", timeZoneDataType._daylightSavingInOffset);
    }

    public static TimeZoneDataType decode(UaDecoder decoder) {
        Short _offset = decoder.decodeInt16("Offset");
        Boolean _daylightSavingInOffset = decoder.decodeBoolean("DaylightSavingInOffset");
        return new TimeZoneDataType(_offset, _daylightSavingInOffset);
    }

    static {
        DelegateRegistry.registerEncoder(TimeZoneDataType::encode, TimeZoneDataType.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(TimeZoneDataType::decode, TimeZoneDataType.class, BinaryEncodingId, XmlEncodingId);
    }
}

