/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.CompositeTestType;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

@UaDataType(value="TestStackExResponse")
public class TestStackExResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.TestStackExResponse;
    public static final NodeId BinaryEncodingId = Identifiers.TestStackExResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.TestStackExResponse_Encoding_DefaultXml;
    protected final ResponseHeader _responseHeader;
    protected final CompositeTestType _output;

    public TestStackExResponse() {
        this._responseHeader = null;
        this._output = null;
    }

    public TestStackExResponse(ResponseHeader _responseHeader, CompositeTestType _output) {
        this._responseHeader = _responseHeader;
        this._output = _output;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this._responseHeader;
    }

    public CompositeTestType getOutput() {
        return this._output;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public static void encode(TestStackExResponse testStackExResponse, UaEncoder encoder) {
        encoder.encodeSerializable("ResponseHeader", testStackExResponse._responseHeader != null ? testStackExResponse._responseHeader : new ResponseHeader());
        encoder.encodeSerializable("Output", testStackExResponse._output != null ? testStackExResponse._output : new CompositeTestType());
    }

    public static TestStackExResponse decode(UaDecoder decoder) {
        ResponseHeader _responseHeader = decoder.decodeSerializable("ResponseHeader", ResponseHeader.class);
        CompositeTestType _output = decoder.decodeSerializable("Output", CompositeTestType.class);
        return new TestStackExResponse(_responseHeader, _output);
    }

    static {
        DelegateRegistry.registerEncoder(TestStackExResponse::encode, TestStackExResponse.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(TestStackExResponse::decode, TestStackExResponse.class, BinaryEncodingId, XmlEncodingId);
    }
}

