/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.NotificationData;

@UaDataType(value="StatusChangeNotification")
public class StatusChangeNotification
extends NotificationData {
    public static final NodeId TypeId = Identifiers.StatusChangeNotification;
    public static final NodeId BinaryEncodingId = Identifiers.StatusChangeNotification_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.StatusChangeNotification_Encoding_DefaultXml;
    protected final StatusCode _status;
    protected final DiagnosticInfo _diagnosticInfo;

    public StatusChangeNotification() {
        this._status = null;
        this._diagnosticInfo = null;
    }

    public StatusChangeNotification(StatusCode _status, DiagnosticInfo _diagnosticInfo) {
        this._status = _status;
        this._diagnosticInfo = _diagnosticInfo;
    }

    public StatusCode getStatus() {
        return this._status;
    }

    public DiagnosticInfo getDiagnosticInfo() {
        return this._diagnosticInfo;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Status", (Object)this._status).add("DiagnosticInfo", (Object)this._diagnosticInfo).toString();
    }

    public static void encode(StatusChangeNotification statusChangeNotification, UaEncoder encoder) {
        encoder.encodeStatusCode("Status", statusChangeNotification._status);
        encoder.encodeDiagnosticInfo("DiagnosticInfo", statusChangeNotification._diagnosticInfo);
    }

    public static StatusChangeNotification decode(UaDecoder decoder) {
        StatusCode _status = decoder.decodeStatusCode("Status");
        DiagnosticInfo _diagnosticInfo = decoder.decodeDiagnosticInfo("DiagnosticInfo");
        return new StatusChangeNotification(_status, _diagnosticInfo);
    }

    static {
        DelegateRegistry.registerEncoder(StatusChangeNotification::encode, StatusChangeNotification.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(StatusChangeNotification::decode, StatusChangeNotification.class, BinaryEncodingId, XmlEncodingId);
    }
}

