/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.SupportedProfile;

@UaDataType(value="SoftwareCertificate")
public class SoftwareCertificate
implements UaStructure {
    public static final NodeId TypeId = Identifiers.SoftwareCertificate;
    public static final NodeId BinaryEncodingId = Identifiers.SoftwareCertificate_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.SoftwareCertificate_Encoding_DefaultXml;
    protected final String _productName;
    protected final String _productUri;
    protected final String _vendorName;
    protected final ByteString _vendorProductCertificate;
    protected final String _softwareVersion;
    protected final String _buildNumber;
    protected final DateTime _buildDate;
    protected final String _issuedBy;
    protected final DateTime _issueDate;
    protected final SupportedProfile[] _supportedProfiles;

    public SoftwareCertificate() {
        this._productName = null;
        this._productUri = null;
        this._vendorName = null;
        this._vendorProductCertificate = null;
        this._softwareVersion = null;
        this._buildNumber = null;
        this._buildDate = null;
        this._issuedBy = null;
        this._issueDate = null;
        this._supportedProfiles = null;
    }

    public SoftwareCertificate(String _productName, String _productUri, String _vendorName, ByteString _vendorProductCertificate, String _softwareVersion, String _buildNumber, DateTime _buildDate, String _issuedBy, DateTime _issueDate, SupportedProfile[] _supportedProfiles) {
        this._productName = _productName;
        this._productUri = _productUri;
        this._vendorName = _vendorName;
        this._vendorProductCertificate = _vendorProductCertificate;
        this._softwareVersion = _softwareVersion;
        this._buildNumber = _buildNumber;
        this._buildDate = _buildDate;
        this._issuedBy = _issuedBy;
        this._issueDate = _issueDate;
        this._supportedProfiles = _supportedProfiles;
    }

    public String getProductName() {
        return this._productName;
    }

    public String getProductUri() {
        return this._productUri;
    }

    public String getVendorName() {
        return this._vendorName;
    }

    public ByteString getVendorProductCertificate() {
        return this._vendorProductCertificate;
    }

    public String getSoftwareVersion() {
        return this._softwareVersion;
    }

    public String getBuildNumber() {
        return this._buildNumber;
    }

    public DateTime getBuildDate() {
        return this._buildDate;
    }

    public String getIssuedBy() {
        return this._issuedBy;
    }

    public DateTime getIssueDate() {
        return this._issueDate;
    }

    @Nullable
    public SupportedProfile[] getSupportedProfiles() {
        return this._supportedProfiles;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ProductName", (Object)this._productName).add("ProductUri", (Object)this._productUri).add("VendorName", (Object)this._vendorName).add("VendorProductCertificate", (Object)this._vendorProductCertificate).add("SoftwareVersion", (Object)this._softwareVersion).add("BuildNumber", (Object)this._buildNumber).add("BuildDate", (Object)this._buildDate).add("IssuedBy", (Object)this._issuedBy).add("IssueDate", (Object)this._issueDate).add("SupportedProfiles", (Object)this._supportedProfiles).toString();
    }

    public static void encode(SoftwareCertificate softwareCertificate, UaEncoder encoder) {
        encoder.encodeString("ProductName", softwareCertificate._productName);
        encoder.encodeString("ProductUri", softwareCertificate._productUri);
        encoder.encodeString("VendorName", softwareCertificate._vendorName);
        encoder.encodeByteString("VendorProductCertificate", softwareCertificate._vendorProductCertificate);
        encoder.encodeString("SoftwareVersion", softwareCertificate._softwareVersion);
        encoder.encodeString("BuildNumber", softwareCertificate._buildNumber);
        encoder.encodeDateTime("BuildDate", softwareCertificate._buildDate);
        encoder.encodeString("IssuedBy", softwareCertificate._issuedBy);
        encoder.encodeDateTime("IssueDate", softwareCertificate._issueDate);
        encoder.encodeArray("SupportedProfiles", softwareCertificate._supportedProfiles, encoder::encodeSerializable);
    }

    public static SoftwareCertificate decode(UaDecoder decoder) {
        String _productName = decoder.decodeString("ProductName");
        String _productUri = decoder.decodeString("ProductUri");
        String _vendorName = decoder.decodeString("VendorName");
        ByteString _vendorProductCertificate = decoder.decodeByteString("VendorProductCertificate");
        String _softwareVersion = decoder.decodeString("SoftwareVersion");
        String _buildNumber = decoder.decodeString("BuildNumber");
        DateTime _buildDate = decoder.decodeDateTime("BuildDate");
        String _issuedBy = decoder.decodeString("IssuedBy");
        DateTime _issueDate = decoder.decodeDateTime("IssueDate");
        SupportedProfile[] _supportedProfiles = decoder.decodeArray("SupportedProfiles", decoder::decodeSerializable, SupportedProfile.class);
        return new SoftwareCertificate(_productName, _productUri, _vendorName, _vendorProductCertificate, _softwareVersion, _buildNumber, _buildDate, _issuedBy, _issueDate, _supportedProfiles);
    }

    static {
        DelegateRegistry.registerEncoder(SoftwareCertificate::encode, SoftwareCertificate.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(SoftwareCertificate::decode, SoftwareCertificate.class, BinaryEncodingId, XmlEncodingId);
    }
}

