/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

@UaDataType(value="SignatureData")
public class SignatureData
implements UaStructure {
    public static final NodeId TypeId = Identifiers.SignatureData;
    public static final NodeId BinaryEncodingId = Identifiers.SignatureData_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.SignatureData_Encoding_DefaultXml;
    protected final String _algorithm;
    protected final ByteString _signature;

    public SignatureData() {
        this._algorithm = null;
        this._signature = null;
    }

    public SignatureData(String _algorithm, ByteString _signature) {
        this._algorithm = _algorithm;
        this._signature = _signature;
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public ByteString getSignature() {
        return this._signature;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Algorithm", (Object)this._algorithm).add("Signature", (Object)this._signature).toString();
    }

    public static void encode(SignatureData signatureData, UaEncoder encoder) {
        encoder.encodeString("Algorithm", signatureData._algorithm);
        encoder.encodeByteString("Signature", signatureData._signature);
    }

    public static SignatureData decode(UaDecoder decoder) {
        String _algorithm = decoder.decodeString("Algorithm");
        ByteString _signature = decoder.decodeByteString("Signature");
        return new SignatureData(_algorithm, _signature);
    }

    static {
        DelegateRegistry.registerEncoder(SignatureData::encode, SignatureData.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(SignatureData::decode, SignatureData.class, BinaryEncodingId, XmlEncodingId);
    }
}

