/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

@UaDataType(value="SetTriggeringResponse")
public class SetTriggeringResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.SetTriggeringResponse;
    public static final NodeId BinaryEncodingId = Identifiers.SetTriggeringResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.SetTriggeringResponse_Encoding_DefaultXml;
    protected final ResponseHeader _responseHeader;
    protected final StatusCode[] _addResults;
    protected final DiagnosticInfo[] _addDiagnosticInfos;
    protected final StatusCode[] _removeResults;
    protected final DiagnosticInfo[] _removeDiagnosticInfos;

    public SetTriggeringResponse() {
        this._responseHeader = null;
        this._addResults = null;
        this._addDiagnosticInfos = null;
        this._removeResults = null;
        this._removeDiagnosticInfos = null;
    }

    public SetTriggeringResponse(ResponseHeader _responseHeader, StatusCode[] _addResults, DiagnosticInfo[] _addDiagnosticInfos, StatusCode[] _removeResults, DiagnosticInfo[] _removeDiagnosticInfos) {
        this._responseHeader = _responseHeader;
        this._addResults = _addResults;
        this._addDiagnosticInfos = _addDiagnosticInfos;
        this._removeResults = _removeResults;
        this._removeDiagnosticInfos = _removeDiagnosticInfos;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this._responseHeader;
    }

    @Nullable
    public StatusCode[] getAddResults() {
        return this._addResults;
    }

    @Nullable
    public DiagnosticInfo[] getAddDiagnosticInfos() {
        return this._addDiagnosticInfos;
    }

    @Nullable
    public StatusCode[] getRemoveResults() {
        return this._removeResults;
    }

    @Nullable
    public DiagnosticInfo[] getRemoveDiagnosticInfos() {
        return this._removeDiagnosticInfos;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this._responseHeader).add("AddResults", (Object)this._addResults).add("AddDiagnosticInfos", (Object)this._addDiagnosticInfos).add("RemoveResults", (Object)this._removeResults).add("RemoveDiagnosticInfos", (Object)this._removeDiagnosticInfos).toString();
    }

    public static void encode(SetTriggeringResponse setTriggeringResponse, UaEncoder encoder) {
        encoder.encodeSerializable("ResponseHeader", setTriggeringResponse._responseHeader != null ? setTriggeringResponse._responseHeader : new ResponseHeader());
        encoder.encodeArray("AddResults", setTriggeringResponse._addResults, encoder::encodeStatusCode);
        encoder.encodeArray("AddDiagnosticInfos", setTriggeringResponse._addDiagnosticInfos, encoder::encodeDiagnosticInfo);
        encoder.encodeArray("RemoveResults", setTriggeringResponse._removeResults, encoder::encodeStatusCode);
        encoder.encodeArray("RemoveDiagnosticInfos", setTriggeringResponse._removeDiagnosticInfos, encoder::encodeDiagnosticInfo);
    }

    public static SetTriggeringResponse decode(UaDecoder decoder) {
        ResponseHeader _responseHeader = decoder.decodeSerializable("ResponseHeader", ResponseHeader.class);
        StatusCode[] _addResults = decoder.decodeArray("AddResults", decoder::decodeStatusCode, StatusCode.class);
        DiagnosticInfo[] _addDiagnosticInfos = decoder.decodeArray("AddDiagnosticInfos", decoder::decodeDiagnosticInfo, DiagnosticInfo.class);
        StatusCode[] _removeResults = decoder.decodeArray("RemoveResults", decoder::decodeStatusCode, StatusCode.class);
        DiagnosticInfo[] _removeDiagnosticInfos = decoder.decodeArray("RemoveDiagnosticInfos", decoder::decodeDiagnosticInfo, DiagnosticInfo.class);
        return new SetTriggeringResponse(_responseHeader, _addResults, _addDiagnosticInfos, _removeResults, _removeDiagnosticInfos);
    }

    static {
        DelegateRegistry.registerEncoder(SetTriggeringResponse::encode, SetTriggeringResponse.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(SetTriggeringResponse::decode, SetTriggeringResponse.class, BinaryEncodingId, XmlEncodingId);
    }
}

