/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceCounterDataType;

@UaDataType(value="SessionDiagnosticsDataType")
public class SessionDiagnosticsDataType
implements UaStructure {
    public static final NodeId TypeId = Identifiers.SessionDiagnosticsDataType;
    public static final NodeId BinaryEncodingId = Identifiers.SessionDiagnosticsDataType_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.SessionDiagnosticsDataType_Encoding_DefaultXml;
    protected final NodeId _sessionId;
    protected final String _sessionName;
    protected final ApplicationDescription _clientDescription;
    protected final String _serverUri;
    protected final String _endpointUrl;
    protected final String[] _localeIds;
    protected final Double _actualSessionTimeout;
    protected final UInteger _maxResponseMessageSize;
    protected final DateTime _clientConnectionTime;
    protected final DateTime _clientLastContactTime;
    protected final UInteger _currentSubscriptionsCount;
    protected final UInteger _currentMonitoredItemsCount;
    protected final UInteger _currentPublishRequestsInQueue;
    protected final ServiceCounterDataType _totalRequestCount;
    protected final UInteger _unauthorizedRequestCount;
    protected final ServiceCounterDataType _readCount;
    protected final ServiceCounterDataType _historyReadCount;
    protected final ServiceCounterDataType _writeCount;
    protected final ServiceCounterDataType _historyUpdateCount;
    protected final ServiceCounterDataType _callCount;
    protected final ServiceCounterDataType _createMonitoredItemsCount;
    protected final ServiceCounterDataType _modifyMonitoredItemsCount;
    protected final ServiceCounterDataType _setMonitoringModeCount;
    protected final ServiceCounterDataType _setTriggeringCount;
    protected final ServiceCounterDataType _deleteMonitoredItemsCount;
    protected final ServiceCounterDataType _createSubscriptionCount;
    protected final ServiceCounterDataType _modifySubscriptionCount;
    protected final ServiceCounterDataType _setPublishingModeCount;
    protected final ServiceCounterDataType _publishCount;
    protected final ServiceCounterDataType _republishCount;
    protected final ServiceCounterDataType _transferSubscriptionsCount;
    protected final ServiceCounterDataType _deleteSubscriptionsCount;
    protected final ServiceCounterDataType _addNodesCount;
    protected final ServiceCounterDataType _addReferencesCount;
    protected final ServiceCounterDataType _deleteNodesCount;
    protected final ServiceCounterDataType _deleteReferencesCount;
    protected final ServiceCounterDataType _browseCount;
    protected final ServiceCounterDataType _browseNextCount;
    protected final ServiceCounterDataType _translateBrowsePathsToNodeIdsCount;
    protected final ServiceCounterDataType _queryFirstCount;
    protected final ServiceCounterDataType _queryNextCount;
    protected final ServiceCounterDataType _registerNodesCount;
    protected final ServiceCounterDataType _unregisterNodesCount;

    public SessionDiagnosticsDataType() {
        this._sessionId = null;
        this._sessionName = null;
        this._clientDescription = null;
        this._serverUri = null;
        this._endpointUrl = null;
        this._localeIds = null;
        this._actualSessionTimeout = null;
        this._maxResponseMessageSize = null;
        this._clientConnectionTime = null;
        this._clientLastContactTime = null;
        this._currentSubscriptionsCount = null;
        this._currentMonitoredItemsCount = null;
        this._currentPublishRequestsInQueue = null;
        this._totalRequestCount = null;
        this._unauthorizedRequestCount = null;
        this._readCount = null;
        this._historyReadCount = null;
        this._writeCount = null;
        this._historyUpdateCount = null;
        this._callCount = null;
        this._createMonitoredItemsCount = null;
        this._modifyMonitoredItemsCount = null;
        this._setMonitoringModeCount = null;
        this._setTriggeringCount = null;
        this._deleteMonitoredItemsCount = null;
        this._createSubscriptionCount = null;
        this._modifySubscriptionCount = null;
        this._setPublishingModeCount = null;
        this._publishCount = null;
        this._republishCount = null;
        this._transferSubscriptionsCount = null;
        this._deleteSubscriptionsCount = null;
        this._addNodesCount = null;
        this._addReferencesCount = null;
        this._deleteNodesCount = null;
        this._deleteReferencesCount = null;
        this._browseCount = null;
        this._browseNextCount = null;
        this._translateBrowsePathsToNodeIdsCount = null;
        this._queryFirstCount = null;
        this._queryNextCount = null;
        this._registerNodesCount = null;
        this._unregisterNodesCount = null;
    }

    public SessionDiagnosticsDataType(NodeId _sessionId, String _sessionName, ApplicationDescription _clientDescription, String _serverUri, String _endpointUrl, String[] _localeIds, Double _actualSessionTimeout, UInteger _maxResponseMessageSize, DateTime _clientConnectionTime, DateTime _clientLastContactTime, UInteger _currentSubscriptionsCount, UInteger _currentMonitoredItemsCount, UInteger _currentPublishRequestsInQueue, ServiceCounterDataType _totalRequestCount, UInteger _unauthorizedRequestCount, ServiceCounterDataType _readCount, ServiceCounterDataType _historyReadCount, ServiceCounterDataType _writeCount, ServiceCounterDataType _historyUpdateCount, ServiceCounterDataType _callCount, ServiceCounterDataType _createMonitoredItemsCount, ServiceCounterDataType _modifyMonitoredItemsCount, ServiceCounterDataType _setMonitoringModeCount, ServiceCounterDataType _setTriggeringCount, ServiceCounterDataType _deleteMonitoredItemsCount, ServiceCounterDataType _createSubscriptionCount, ServiceCounterDataType _modifySubscriptionCount, ServiceCounterDataType _setPublishingModeCount, ServiceCounterDataType _publishCount, ServiceCounterDataType _republishCount, ServiceCounterDataType _transferSubscriptionsCount, ServiceCounterDataType _deleteSubscriptionsCount, ServiceCounterDataType _addNodesCount, ServiceCounterDataType _addReferencesCount, ServiceCounterDataType _deleteNodesCount, ServiceCounterDataType _deleteReferencesCount, ServiceCounterDataType _browseCount, ServiceCounterDataType _browseNextCount, ServiceCounterDataType _translateBrowsePathsToNodeIdsCount, ServiceCounterDataType _queryFirstCount, ServiceCounterDataType _queryNextCount, ServiceCounterDataType _registerNodesCount, ServiceCounterDataType _unregisterNodesCount) {
        this._sessionId = _sessionId;
        this._sessionName = _sessionName;
        this._clientDescription = _clientDescription;
        this._serverUri = _serverUri;
        this._endpointUrl = _endpointUrl;
        this._localeIds = _localeIds;
        this._actualSessionTimeout = _actualSessionTimeout;
        this._maxResponseMessageSize = _maxResponseMessageSize;
        this._clientConnectionTime = _clientConnectionTime;
        this._clientLastContactTime = _clientLastContactTime;
        this._currentSubscriptionsCount = _currentSubscriptionsCount;
        this._currentMonitoredItemsCount = _currentMonitoredItemsCount;
        this._currentPublishRequestsInQueue = _currentPublishRequestsInQueue;
        this._totalRequestCount = _totalRequestCount;
        this._unauthorizedRequestCount = _unauthorizedRequestCount;
        this._readCount = _readCount;
        this._historyReadCount = _historyReadCount;
        this._writeCount = _writeCount;
        this._historyUpdateCount = _historyUpdateCount;
        this._callCount = _callCount;
        this._createMonitoredItemsCount = _createMonitoredItemsCount;
        this._modifyMonitoredItemsCount = _modifyMonitoredItemsCount;
        this._setMonitoringModeCount = _setMonitoringModeCount;
        this._setTriggeringCount = _setTriggeringCount;
        this._deleteMonitoredItemsCount = _deleteMonitoredItemsCount;
        this._createSubscriptionCount = _createSubscriptionCount;
        this._modifySubscriptionCount = _modifySubscriptionCount;
        this._setPublishingModeCount = _setPublishingModeCount;
        this._publishCount = _publishCount;
        this._republishCount = _republishCount;
        this._transferSubscriptionsCount = _transferSubscriptionsCount;
        this._deleteSubscriptionsCount = _deleteSubscriptionsCount;
        this._addNodesCount = _addNodesCount;
        this._addReferencesCount = _addReferencesCount;
        this._deleteNodesCount = _deleteNodesCount;
        this._deleteReferencesCount = _deleteReferencesCount;
        this._browseCount = _browseCount;
        this._browseNextCount = _browseNextCount;
        this._translateBrowsePathsToNodeIdsCount = _translateBrowsePathsToNodeIdsCount;
        this._queryFirstCount = _queryFirstCount;
        this._queryNextCount = _queryNextCount;
        this._registerNodesCount = _registerNodesCount;
        this._unregisterNodesCount = _unregisterNodesCount;
    }

    public NodeId getSessionId() {
        return this._sessionId;
    }

    public String getSessionName() {
        return this._sessionName;
    }

    public ApplicationDescription getClientDescription() {
        return this._clientDescription;
    }

    public String getServerUri() {
        return this._serverUri;
    }

    public String getEndpointUrl() {
        return this._endpointUrl;
    }

    @Nullable
    public String[] getLocaleIds() {
        return this._localeIds;
    }

    public Double getActualSessionTimeout() {
        return this._actualSessionTimeout;
    }

    public UInteger getMaxResponseMessageSize() {
        return this._maxResponseMessageSize;
    }

    public DateTime getClientConnectionTime() {
        return this._clientConnectionTime;
    }

    public DateTime getClientLastContactTime() {
        return this._clientLastContactTime;
    }

    public UInteger getCurrentSubscriptionsCount() {
        return this._currentSubscriptionsCount;
    }

    public UInteger getCurrentMonitoredItemsCount() {
        return this._currentMonitoredItemsCount;
    }

    public UInteger getCurrentPublishRequestsInQueue() {
        return this._currentPublishRequestsInQueue;
    }

    public ServiceCounterDataType getTotalRequestCount() {
        return this._totalRequestCount;
    }

    public UInteger getUnauthorizedRequestCount() {
        return this._unauthorizedRequestCount;
    }

    public ServiceCounterDataType getReadCount() {
        return this._readCount;
    }

    public ServiceCounterDataType getHistoryReadCount() {
        return this._historyReadCount;
    }

    public ServiceCounterDataType getWriteCount() {
        return this._writeCount;
    }

    public ServiceCounterDataType getHistoryUpdateCount() {
        return this._historyUpdateCount;
    }

    public ServiceCounterDataType getCallCount() {
        return this._callCount;
    }

    public ServiceCounterDataType getCreateMonitoredItemsCount() {
        return this._createMonitoredItemsCount;
    }

    public ServiceCounterDataType getModifyMonitoredItemsCount() {
        return this._modifyMonitoredItemsCount;
    }

    public ServiceCounterDataType getSetMonitoringModeCount() {
        return this._setMonitoringModeCount;
    }

    public ServiceCounterDataType getSetTriggeringCount() {
        return this._setTriggeringCount;
    }

    public ServiceCounterDataType getDeleteMonitoredItemsCount() {
        return this._deleteMonitoredItemsCount;
    }

    public ServiceCounterDataType getCreateSubscriptionCount() {
        return this._createSubscriptionCount;
    }

    public ServiceCounterDataType getModifySubscriptionCount() {
        return this._modifySubscriptionCount;
    }

    public ServiceCounterDataType getSetPublishingModeCount() {
        return this._setPublishingModeCount;
    }

    public ServiceCounterDataType getPublishCount() {
        return this._publishCount;
    }

    public ServiceCounterDataType getRepublishCount() {
        return this._republishCount;
    }

    public ServiceCounterDataType getTransferSubscriptionsCount() {
        return this._transferSubscriptionsCount;
    }

    public ServiceCounterDataType getDeleteSubscriptionsCount() {
        return this._deleteSubscriptionsCount;
    }

    public ServiceCounterDataType getAddNodesCount() {
        return this._addNodesCount;
    }

    public ServiceCounterDataType getAddReferencesCount() {
        return this._addReferencesCount;
    }

    public ServiceCounterDataType getDeleteNodesCount() {
        return this._deleteNodesCount;
    }

    public ServiceCounterDataType getDeleteReferencesCount() {
        return this._deleteReferencesCount;
    }

    public ServiceCounterDataType getBrowseCount() {
        return this._browseCount;
    }

    public ServiceCounterDataType getBrowseNextCount() {
        return this._browseNextCount;
    }

    public ServiceCounterDataType getTranslateBrowsePathsToNodeIdsCount() {
        return this._translateBrowsePathsToNodeIdsCount;
    }

    public ServiceCounterDataType getQueryFirstCount() {
        return this._queryFirstCount;
    }

    public ServiceCounterDataType getQueryNextCount() {
        return this._queryNextCount;
    }

    public ServiceCounterDataType getRegisterNodesCount() {
        return this._registerNodesCount;
    }

    public ServiceCounterDataType getUnregisterNodesCount() {
        return this._unregisterNodesCount;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("SessionId", (Object)this._sessionId).add("SessionName", (Object)this._sessionName).add("ClientDescription", (Object)this._clientDescription).add("ServerUri", (Object)this._serverUri).add("EndpointUrl", (Object)this._endpointUrl).add("LocaleIds", (Object)this._localeIds).add("ActualSessionTimeout", (Object)this._actualSessionTimeout).add("MaxResponseMessageSize", (Object)this._maxResponseMessageSize).add("ClientConnectionTime", (Object)this._clientConnectionTime).add("ClientLastContactTime", (Object)this._clientLastContactTime).add("CurrentSubscriptionsCount", (Object)this._currentSubscriptionsCount).add("CurrentMonitoredItemsCount", (Object)this._currentMonitoredItemsCount).add("CurrentPublishRequestsInQueue", (Object)this._currentPublishRequestsInQueue).add("TotalRequestCount", (Object)this._totalRequestCount).add("UnauthorizedRequestCount", (Object)this._unauthorizedRequestCount).add("ReadCount", (Object)this._readCount).add("HistoryReadCount", (Object)this._historyReadCount).add("WriteCount", (Object)this._writeCount).add("HistoryUpdateCount", (Object)this._historyUpdateCount).add("CallCount", (Object)this._callCount).add("CreateMonitoredItemsCount", (Object)this._createMonitoredItemsCount).add("ModifyMonitoredItemsCount", (Object)this._modifyMonitoredItemsCount).add("SetMonitoringModeCount", (Object)this._setMonitoringModeCount).add("SetTriggeringCount", (Object)this._setTriggeringCount).add("DeleteMonitoredItemsCount", (Object)this._deleteMonitoredItemsCount).add("CreateSubscriptionCount", (Object)this._createSubscriptionCount).add("ModifySubscriptionCount", (Object)this._modifySubscriptionCount).add("SetPublishingModeCount", (Object)this._setPublishingModeCount).add("PublishCount", (Object)this._publishCount).add("RepublishCount", (Object)this._republishCount).add("TransferSubscriptionsCount", (Object)this._transferSubscriptionsCount).add("DeleteSubscriptionsCount", (Object)this._deleteSubscriptionsCount).add("AddNodesCount", (Object)this._addNodesCount).add("AddReferencesCount", (Object)this._addReferencesCount).add("DeleteNodesCount", (Object)this._deleteNodesCount).add("DeleteReferencesCount", (Object)this._deleteReferencesCount).add("BrowseCount", (Object)this._browseCount).add("BrowseNextCount", (Object)this._browseNextCount).add("TranslateBrowsePathsToNodeIdsCount", (Object)this._translateBrowsePathsToNodeIdsCount).add("QueryFirstCount", (Object)this._queryFirstCount).add("QueryNextCount", (Object)this._queryNextCount).add("RegisterNodesCount", (Object)this._registerNodesCount).add("UnregisterNodesCount", (Object)this._unregisterNodesCount).toString();
    }

    public static void encode(SessionDiagnosticsDataType sessionDiagnosticsDataType, UaEncoder encoder) {
        encoder.encodeNodeId("SessionId", sessionDiagnosticsDataType._sessionId);
        encoder.encodeString("SessionName", sessionDiagnosticsDataType._sessionName);
        encoder.encodeSerializable("ClientDescription", sessionDiagnosticsDataType._clientDescription != null ? sessionDiagnosticsDataType._clientDescription : new ApplicationDescription());
        encoder.encodeString("ServerUri", sessionDiagnosticsDataType._serverUri);
        encoder.encodeString("EndpointUrl", sessionDiagnosticsDataType._endpointUrl);
        encoder.encodeArray("LocaleIds", sessionDiagnosticsDataType._localeIds, encoder::encodeString);
        encoder.encodeDouble("ActualSessionTimeout", sessionDiagnosticsDataType._actualSessionTimeout);
        encoder.encodeUInt32("MaxResponseMessageSize", sessionDiagnosticsDataType._maxResponseMessageSize);
        encoder.encodeDateTime("ClientConnectionTime", sessionDiagnosticsDataType._clientConnectionTime);
        encoder.encodeDateTime("ClientLastContactTime", sessionDiagnosticsDataType._clientLastContactTime);
        encoder.encodeUInt32("CurrentSubscriptionsCount", sessionDiagnosticsDataType._currentSubscriptionsCount);
        encoder.encodeUInt32("CurrentMonitoredItemsCount", sessionDiagnosticsDataType._currentMonitoredItemsCount);
        encoder.encodeUInt32("CurrentPublishRequestsInQueue", sessionDiagnosticsDataType._currentPublishRequestsInQueue);
        encoder.encodeSerializable("TotalRequestCount", sessionDiagnosticsDataType._totalRequestCount != null ? sessionDiagnosticsDataType._totalRequestCount : new ServiceCounterDataType());
        encoder.encodeUInt32("UnauthorizedRequestCount", sessionDiagnosticsDataType._unauthorizedRequestCount);
        encoder.encodeSerializable("ReadCount", sessionDiagnosticsDataType._readCount != null ? sessionDiagnosticsDataType._readCount : new ServiceCounterDataType());
        encoder.encodeSerializable("HistoryReadCount", sessionDiagnosticsDataType._historyReadCount != null ? sessionDiagnosticsDataType._historyReadCount : new ServiceCounterDataType());
        encoder.encodeSerializable("WriteCount", sessionDiagnosticsDataType._writeCount != null ? sessionDiagnosticsDataType._writeCount : new ServiceCounterDataType());
        encoder.encodeSerializable("HistoryUpdateCount", sessionDiagnosticsDataType._historyUpdateCount != null ? sessionDiagnosticsDataType._historyUpdateCount : new ServiceCounterDataType());
        encoder.encodeSerializable("CallCount", sessionDiagnosticsDataType._callCount != null ? sessionDiagnosticsDataType._callCount : new ServiceCounterDataType());
        encoder.encodeSerializable("CreateMonitoredItemsCount", sessionDiagnosticsDataType._createMonitoredItemsCount != null ? sessionDiagnosticsDataType._createMonitoredItemsCount : new ServiceCounterDataType());
        encoder.encodeSerializable("ModifyMonitoredItemsCount", sessionDiagnosticsDataType._modifyMonitoredItemsCount != null ? sessionDiagnosticsDataType._modifyMonitoredItemsCount : new ServiceCounterDataType());
        encoder.encodeSerializable("SetMonitoringModeCount", sessionDiagnosticsDataType._setMonitoringModeCount != null ? sessionDiagnosticsDataType._setMonitoringModeCount : new ServiceCounterDataType());
        encoder.encodeSerializable("SetTriggeringCount", sessionDiagnosticsDataType._setTriggeringCount != null ? sessionDiagnosticsDataType._setTriggeringCount : new ServiceCounterDataType());
        encoder.encodeSerializable("DeleteMonitoredItemsCount", sessionDiagnosticsDataType._deleteMonitoredItemsCount != null ? sessionDiagnosticsDataType._deleteMonitoredItemsCount : new ServiceCounterDataType());
        encoder.encodeSerializable("CreateSubscriptionCount", sessionDiagnosticsDataType._createSubscriptionCount != null ? sessionDiagnosticsDataType._createSubscriptionCount : new ServiceCounterDataType());
        encoder.encodeSerializable("ModifySubscriptionCount", sessionDiagnosticsDataType._modifySubscriptionCount != null ? sessionDiagnosticsDataType._modifySubscriptionCount : new ServiceCounterDataType());
        encoder.encodeSerializable("SetPublishingModeCount", sessionDiagnosticsDataType._setPublishingModeCount != null ? sessionDiagnosticsDataType._setPublishingModeCount : new ServiceCounterDataType());
        encoder.encodeSerializable("PublishCount", sessionDiagnosticsDataType._publishCount != null ? sessionDiagnosticsDataType._publishCount : new ServiceCounterDataType());
        encoder.encodeSerializable("RepublishCount", sessionDiagnosticsDataType._republishCount != null ? sessionDiagnosticsDataType._republishCount : new ServiceCounterDataType());
        encoder.encodeSerializable("TransferSubscriptionsCount", sessionDiagnosticsDataType._transferSubscriptionsCount != null ? sessionDiagnosticsDataType._transferSubscriptionsCount : new ServiceCounterDataType());
        encoder.encodeSerializable("DeleteSubscriptionsCount", sessionDiagnosticsDataType._deleteSubscriptionsCount != null ? sessionDiagnosticsDataType._deleteSubscriptionsCount : new ServiceCounterDataType());
        encoder.encodeSerializable("AddNodesCount", sessionDiagnosticsDataType._addNodesCount != null ? sessionDiagnosticsDataType._addNodesCount : new ServiceCounterDataType());
        encoder.encodeSerializable("AddReferencesCount", sessionDiagnosticsDataType._addReferencesCount != null ? sessionDiagnosticsDataType._addReferencesCount : new ServiceCounterDataType());
        encoder.encodeSerializable("DeleteNodesCount", sessionDiagnosticsDataType._deleteNodesCount != null ? sessionDiagnosticsDataType._deleteNodesCount : new ServiceCounterDataType());
        encoder.encodeSerializable("DeleteReferencesCount", sessionDiagnosticsDataType._deleteReferencesCount != null ? sessionDiagnosticsDataType._deleteReferencesCount : new ServiceCounterDataType());
        encoder.encodeSerializable("BrowseCount", sessionDiagnosticsDataType._browseCount != null ? sessionDiagnosticsDataType._browseCount : new ServiceCounterDataType());
        encoder.encodeSerializable("BrowseNextCount", sessionDiagnosticsDataType._browseNextCount != null ? sessionDiagnosticsDataType._browseNextCount : new ServiceCounterDataType());
        encoder.encodeSerializable("TranslateBrowsePathsToNodeIdsCount", sessionDiagnosticsDataType._translateBrowsePathsToNodeIdsCount != null ? sessionDiagnosticsDataType._translateBrowsePathsToNodeIdsCount : new ServiceCounterDataType());
        encoder.encodeSerializable("QueryFirstCount", sessionDiagnosticsDataType._queryFirstCount != null ? sessionDiagnosticsDataType._queryFirstCount : new ServiceCounterDataType());
        encoder.encodeSerializable("QueryNextCount", sessionDiagnosticsDataType._queryNextCount != null ? sessionDiagnosticsDataType._queryNextCount : new ServiceCounterDataType());
        encoder.encodeSerializable("RegisterNodesCount", sessionDiagnosticsDataType._registerNodesCount != null ? sessionDiagnosticsDataType._registerNodesCount : new ServiceCounterDataType());
        encoder.encodeSerializable("UnregisterNodesCount", sessionDiagnosticsDataType._unregisterNodesCount != null ? sessionDiagnosticsDataType._unregisterNodesCount : new ServiceCounterDataType());
    }

    public static SessionDiagnosticsDataType decode(UaDecoder decoder) {
        NodeId _sessionId = decoder.decodeNodeId("SessionId");
        String _sessionName = decoder.decodeString("SessionName");
        ApplicationDescription _clientDescription = decoder.decodeSerializable("ClientDescription", ApplicationDescription.class);
        String _serverUri = decoder.decodeString("ServerUri");
        String _endpointUrl = decoder.decodeString("EndpointUrl");
        String[] _localeIds = decoder.decodeArray("LocaleIds", decoder::decodeString, String.class);
        Double _actualSessionTimeout = decoder.decodeDouble("ActualSessionTimeout");
        UInteger _maxResponseMessageSize = decoder.decodeUInt32("MaxResponseMessageSize");
        DateTime _clientConnectionTime = decoder.decodeDateTime("ClientConnectionTime");
        DateTime _clientLastContactTime = decoder.decodeDateTime("ClientLastContactTime");
        UInteger _currentSubscriptionsCount = decoder.decodeUInt32("CurrentSubscriptionsCount");
        UInteger _currentMonitoredItemsCount = decoder.decodeUInt32("CurrentMonitoredItemsCount");
        UInteger _currentPublishRequestsInQueue = decoder.decodeUInt32("CurrentPublishRequestsInQueue");
        ServiceCounterDataType _totalRequestCount = decoder.decodeSerializable("TotalRequestCount", ServiceCounterDataType.class);
        UInteger _unauthorizedRequestCount = decoder.decodeUInt32("UnauthorizedRequestCount");
        ServiceCounterDataType _readCount = decoder.decodeSerializable("ReadCount", ServiceCounterDataType.class);
        ServiceCounterDataType _historyReadCount = decoder.decodeSerializable("HistoryReadCount", ServiceCounterDataType.class);
        ServiceCounterDataType _writeCount = decoder.decodeSerializable("WriteCount", ServiceCounterDataType.class);
        ServiceCounterDataType _historyUpdateCount = decoder.decodeSerializable("HistoryUpdateCount", ServiceCounterDataType.class);
        ServiceCounterDataType _callCount = decoder.decodeSerializable("CallCount", ServiceCounterDataType.class);
        ServiceCounterDataType _createMonitoredItemsCount = decoder.decodeSerializable("CreateMonitoredItemsCount", ServiceCounterDataType.class);
        ServiceCounterDataType _modifyMonitoredItemsCount = decoder.decodeSerializable("ModifyMonitoredItemsCount", ServiceCounterDataType.class);
        ServiceCounterDataType _setMonitoringModeCount = decoder.decodeSerializable("SetMonitoringModeCount", ServiceCounterDataType.class);
        ServiceCounterDataType _setTriggeringCount = decoder.decodeSerializable("SetTriggeringCount", ServiceCounterDataType.class);
        ServiceCounterDataType _deleteMonitoredItemsCount = decoder.decodeSerializable("DeleteMonitoredItemsCount", ServiceCounterDataType.class);
        ServiceCounterDataType _createSubscriptionCount = decoder.decodeSerializable("CreateSubscriptionCount", ServiceCounterDataType.class);
        ServiceCounterDataType _modifySubscriptionCount = decoder.decodeSerializable("ModifySubscriptionCount", ServiceCounterDataType.class);
        ServiceCounterDataType _setPublishingModeCount = decoder.decodeSerializable("SetPublishingModeCount", ServiceCounterDataType.class);
        ServiceCounterDataType _publishCount = decoder.decodeSerializable("PublishCount", ServiceCounterDataType.class);
        ServiceCounterDataType _republishCount = decoder.decodeSerializable("RepublishCount", ServiceCounterDataType.class);
        ServiceCounterDataType _transferSubscriptionsCount = decoder.decodeSerializable("TransferSubscriptionsCount", ServiceCounterDataType.class);
        ServiceCounterDataType _deleteSubscriptionsCount = decoder.decodeSerializable("DeleteSubscriptionsCount", ServiceCounterDataType.class);
        ServiceCounterDataType _addNodesCount = decoder.decodeSerializable("AddNodesCount", ServiceCounterDataType.class);
        ServiceCounterDataType _addReferencesCount = decoder.decodeSerializable("AddReferencesCount", ServiceCounterDataType.class);
        ServiceCounterDataType _deleteNodesCount = decoder.decodeSerializable("DeleteNodesCount", ServiceCounterDataType.class);
        ServiceCounterDataType _deleteReferencesCount = decoder.decodeSerializable("DeleteReferencesCount", ServiceCounterDataType.class);
        ServiceCounterDataType _browseCount = decoder.decodeSerializable("BrowseCount", ServiceCounterDataType.class);
        ServiceCounterDataType _browseNextCount = decoder.decodeSerializable("BrowseNextCount", ServiceCounterDataType.class);
        ServiceCounterDataType _translateBrowsePathsToNodeIdsCount = decoder.decodeSerializable("TranslateBrowsePathsToNodeIdsCount", ServiceCounterDataType.class);
        ServiceCounterDataType _queryFirstCount = decoder.decodeSerializable("QueryFirstCount", ServiceCounterDataType.class);
        ServiceCounterDataType _queryNextCount = decoder.decodeSerializable("QueryNextCount", ServiceCounterDataType.class);
        ServiceCounterDataType _registerNodesCount = decoder.decodeSerializable("RegisterNodesCount", ServiceCounterDataType.class);
        ServiceCounterDataType _unregisterNodesCount = decoder.decodeSerializable("UnregisterNodesCount", ServiceCounterDataType.class);
        return new SessionDiagnosticsDataType(_sessionId, _sessionName, _clientDescription, _serverUri, _endpointUrl, _localeIds, _actualSessionTimeout, _maxResponseMessageSize, _clientConnectionTime, _clientLastContactTime, _currentSubscriptionsCount, _currentMonitoredItemsCount, _currentPublishRequestsInQueue, _totalRequestCount, _unauthorizedRequestCount, _readCount, _historyReadCount, _writeCount, _historyUpdateCount, _callCount, _createMonitoredItemsCount, _modifyMonitoredItemsCount, _setMonitoringModeCount, _setTriggeringCount, _deleteMonitoredItemsCount, _createSubscriptionCount, _modifySubscriptionCount, _setPublishingModeCount, _publishCount, _republishCount, _transferSubscriptionsCount, _deleteSubscriptionsCount, _addNodesCount, _addReferencesCount, _deleteNodesCount, _deleteReferencesCount, _browseCount, _browseNextCount, _translateBrowsePathsToNodeIdsCount, _queryFirstCount, _queryNextCount, _registerNodesCount, _unregisterNodesCount);
    }

    static {
        DelegateRegistry.registerEncoder(SessionDiagnosticsDataType::encode, SessionDiagnosticsDataType.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(SessionDiagnosticsDataType::decode, SessionDiagnosticsDataType.class, BinaryEncodingId, XmlEncodingId);
    }
}

