/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaDataType(value="ServiceCounterDataType")
public class ServiceCounterDataType
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ServiceCounterDataType;
    public static final NodeId BinaryEncodingId = Identifiers.ServiceCounterDataType_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ServiceCounterDataType_Encoding_DefaultXml;
    protected final UInteger _totalCount;
    protected final UInteger _errorCount;

    public ServiceCounterDataType() {
        this._totalCount = null;
        this._errorCount = null;
    }

    public ServiceCounterDataType(UInteger _totalCount, UInteger _errorCount) {
        this._totalCount = _totalCount;
        this._errorCount = _errorCount;
    }

    public UInteger getTotalCount() {
        return this._totalCount;
    }

    public UInteger getErrorCount() {
        return this._errorCount;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("TotalCount", (Object)this._totalCount).add("ErrorCount", (Object)this._errorCount).toString();
    }

    public static void encode(ServiceCounterDataType serviceCounterDataType, UaEncoder encoder) {
        encoder.encodeUInt32("TotalCount", serviceCounterDataType._totalCount);
        encoder.encodeUInt32("ErrorCount", serviceCounterDataType._errorCount);
    }

    public static ServiceCounterDataType decode(UaDecoder decoder) {
        UInteger _totalCount = decoder.decodeUInt32("TotalCount");
        UInteger _errorCount = decoder.decodeUInt32("ErrorCount");
        return new ServiceCounterDataType(_totalCount, _errorCount);
    }

    static {
        DelegateRegistry.registerEncoder(ServiceCounterDataType::encode, ServiceCounterDataType.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(ServiceCounterDataType::decode, ServiceCounterDataType.class, BinaryEncodingId, XmlEncodingId);
    }
}

