/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaDataType(value="ServerOnNetwork")
public class ServerOnNetwork
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ServerOnNetwork;
    public static final NodeId BinaryEncodingId = Identifiers.ServerOnNetwork_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ServerOnNetwork_Encoding_DefaultXml;
    protected final UInteger _recordId;
    protected final String _serverName;
    protected final String _discoveryUrl;
    protected final String[] _serverCapabilities;

    public ServerOnNetwork() {
        this._recordId = null;
        this._serverName = null;
        this._discoveryUrl = null;
        this._serverCapabilities = null;
    }

    public ServerOnNetwork(UInteger _recordId, String _serverName, String _discoveryUrl, String[] _serverCapabilities) {
        this._recordId = _recordId;
        this._serverName = _serverName;
        this._discoveryUrl = _discoveryUrl;
        this._serverCapabilities = _serverCapabilities;
    }

    public UInteger getRecordId() {
        return this._recordId;
    }

    public String getServerName() {
        return this._serverName;
    }

    public String getDiscoveryUrl() {
        return this._discoveryUrl;
    }

    @Nullable
    public String[] getServerCapabilities() {
        return this._serverCapabilities;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RecordId", (Object)this._recordId).add("ServerName", (Object)this._serverName).add("DiscoveryUrl", (Object)this._discoveryUrl).add("ServerCapabilities", (Object)this._serverCapabilities).toString();
    }

    public static void encode(ServerOnNetwork serverOnNetwork, UaEncoder encoder) {
        encoder.encodeUInt32("RecordId", serverOnNetwork._recordId);
        encoder.encodeString("ServerName", serverOnNetwork._serverName);
        encoder.encodeString("DiscoveryUrl", serverOnNetwork._discoveryUrl);
        encoder.encodeArray("ServerCapabilities", serverOnNetwork._serverCapabilities, encoder::encodeString);
    }

    public static ServerOnNetwork decode(UaDecoder decoder) {
        UInteger _recordId = decoder.decodeUInt32("RecordId");
        String _serverName = decoder.decodeString("ServerName");
        String _discoveryUrl = decoder.decodeString("DiscoveryUrl");
        String[] _serverCapabilities = decoder.decodeArray("ServerCapabilities", decoder::decodeString, String.class);
        return new ServerOnNetwork(_recordId, _serverName, _discoveryUrl, _serverCapabilities);
    }

    static {
        DelegateRegistry.registerEncoder(ServerOnNetwork::encode, ServerOnNetwork.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(ServerOnNetwork::decode, ServerOnNetwork.class, BinaryEncodingId, XmlEncodingId);
    }
}

