/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisteredServer;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

@UaDataType(value="RegisterServer2Request")
public class RegisterServer2Request
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.RegisterServer2Request;
    public static final NodeId BinaryEncodingId = Identifiers.RegisterServer2Request_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.RegisterServer2Request_Encoding_DefaultXml;
    protected final RequestHeader _requestHeader;
    protected final RegisteredServer _server;
    protected final ExtensionObject[] _discoveryConfiguration;

    public RegisterServer2Request() {
        this._requestHeader = null;
        this._server = null;
        this._discoveryConfiguration = null;
    }

    public RegisterServer2Request(RequestHeader _requestHeader, RegisteredServer _server, ExtensionObject[] _discoveryConfiguration) {
        this._requestHeader = _requestHeader;
        this._server = _server;
        this._discoveryConfiguration = _discoveryConfiguration;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this._requestHeader;
    }

    public RegisteredServer getServer() {
        return this._server;
    }

    @Nullable
    public ExtensionObject[] getDiscoveryConfiguration() {
        return this._discoveryConfiguration;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this._requestHeader).add("Server", (Object)this._server).add("DiscoveryConfiguration", (Object)this._discoveryConfiguration).toString();
    }

    public static void encode(RegisterServer2Request registerServer2Request, UaEncoder encoder) {
        encoder.encodeSerializable("RequestHeader", registerServer2Request._requestHeader != null ? registerServer2Request._requestHeader : new RequestHeader());
        encoder.encodeSerializable("Server", registerServer2Request._server != null ? registerServer2Request._server : new RegisteredServer());
        encoder.encodeArray("DiscoveryConfiguration", registerServer2Request._discoveryConfiguration, encoder::encodeExtensionObject);
    }

    public static RegisterServer2Request decode(UaDecoder decoder) {
        RequestHeader _requestHeader = decoder.decodeSerializable("RequestHeader", RequestHeader.class);
        RegisteredServer _server = decoder.decodeSerializable("Server", RegisteredServer.class);
        ExtensionObject[] _discoveryConfiguration = decoder.decodeArray("DiscoveryConfiguration", decoder::decodeExtensionObject, ExtensionObject.class);
        return new RegisterServer2Request(_requestHeader, _server, _discoveryConfiguration);
    }

    static {
        DelegateRegistry.registerEncoder(RegisterServer2Request::encode, RegisterServer2Request.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(RegisterServer2Request::decode, RegisterServer2Request.class, BinaryEncodingId, XmlEncodingId);
    }
}

