/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.StatusResult;

@UaDataType(value="ProgramDiagnosticDataType")
public class ProgramDiagnosticDataType
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ProgramDiagnosticDataType;
    public static final NodeId BinaryEncodingId = Identifiers.ProgramDiagnosticDataType_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ProgramDiagnosticDataType_Encoding_DefaultXml;
    protected final NodeId _createSessionId;
    protected final String _createClientName;
    protected final DateTime _invocationCreationTime;
    protected final DateTime _lastTransitionTime;
    protected final String _lastMethodCall;
    protected final NodeId _lastMethodSessionId;
    protected final Argument[] _lastMethodInputArguments;
    protected final Argument[] _lastMethodOutputArguments;
    protected final DateTime _lastMethodCallTime;
    protected final StatusResult _lastMethodReturnStatus;

    public ProgramDiagnosticDataType() {
        this._createSessionId = null;
        this._createClientName = null;
        this._invocationCreationTime = null;
        this._lastTransitionTime = null;
        this._lastMethodCall = null;
        this._lastMethodSessionId = null;
        this._lastMethodInputArguments = null;
        this._lastMethodOutputArguments = null;
        this._lastMethodCallTime = null;
        this._lastMethodReturnStatus = null;
    }

    public ProgramDiagnosticDataType(NodeId _createSessionId, String _createClientName, DateTime _invocationCreationTime, DateTime _lastTransitionTime, String _lastMethodCall, NodeId _lastMethodSessionId, Argument[] _lastMethodInputArguments, Argument[] _lastMethodOutputArguments, DateTime _lastMethodCallTime, StatusResult _lastMethodReturnStatus) {
        this._createSessionId = _createSessionId;
        this._createClientName = _createClientName;
        this._invocationCreationTime = _invocationCreationTime;
        this._lastTransitionTime = _lastTransitionTime;
        this._lastMethodCall = _lastMethodCall;
        this._lastMethodSessionId = _lastMethodSessionId;
        this._lastMethodInputArguments = _lastMethodInputArguments;
        this._lastMethodOutputArguments = _lastMethodOutputArguments;
        this._lastMethodCallTime = _lastMethodCallTime;
        this._lastMethodReturnStatus = _lastMethodReturnStatus;
    }

    public NodeId getCreateSessionId() {
        return this._createSessionId;
    }

    public String getCreateClientName() {
        return this._createClientName;
    }

    public DateTime getInvocationCreationTime() {
        return this._invocationCreationTime;
    }

    public DateTime getLastTransitionTime() {
        return this._lastTransitionTime;
    }

    public String getLastMethodCall() {
        return this._lastMethodCall;
    }

    public NodeId getLastMethodSessionId() {
        return this._lastMethodSessionId;
    }

    @Nullable
    public Argument[] getLastMethodInputArguments() {
        return this._lastMethodInputArguments;
    }

    @Nullable
    public Argument[] getLastMethodOutputArguments() {
        return this._lastMethodOutputArguments;
    }

    public DateTime getLastMethodCallTime() {
        return this._lastMethodCallTime;
    }

    public StatusResult getLastMethodReturnStatus() {
        return this._lastMethodReturnStatus;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("CreateSessionId", (Object)this._createSessionId).add("CreateClientName", (Object)this._createClientName).add("InvocationCreationTime", (Object)this._invocationCreationTime).add("LastTransitionTime", (Object)this._lastTransitionTime).add("LastMethodCall", (Object)this._lastMethodCall).add("LastMethodSessionId", (Object)this._lastMethodSessionId).add("LastMethodInputArguments", (Object)this._lastMethodInputArguments).add("LastMethodOutputArguments", (Object)this._lastMethodOutputArguments).add("LastMethodCallTime", (Object)this._lastMethodCallTime).add("LastMethodReturnStatus", (Object)this._lastMethodReturnStatus).toString();
    }

    public static void encode(ProgramDiagnosticDataType programDiagnosticDataType, UaEncoder encoder) {
        encoder.encodeNodeId("CreateSessionId", programDiagnosticDataType._createSessionId);
        encoder.encodeString("CreateClientName", programDiagnosticDataType._createClientName);
        encoder.encodeDateTime("InvocationCreationTime", programDiagnosticDataType._invocationCreationTime);
        encoder.encodeDateTime("LastTransitionTime", programDiagnosticDataType._lastTransitionTime);
        encoder.encodeString("LastMethodCall", programDiagnosticDataType._lastMethodCall);
        encoder.encodeNodeId("LastMethodSessionId", programDiagnosticDataType._lastMethodSessionId);
        encoder.encodeArray("LastMethodInputArguments", programDiagnosticDataType._lastMethodInputArguments, encoder::encodeSerializable);
        encoder.encodeArray("LastMethodOutputArguments", programDiagnosticDataType._lastMethodOutputArguments, encoder::encodeSerializable);
        encoder.encodeDateTime("LastMethodCallTime", programDiagnosticDataType._lastMethodCallTime);
        encoder.encodeSerializable("LastMethodReturnStatus", programDiagnosticDataType._lastMethodReturnStatus != null ? programDiagnosticDataType._lastMethodReturnStatus : new StatusResult());
    }

    public static ProgramDiagnosticDataType decode(UaDecoder decoder) {
        NodeId _createSessionId = decoder.decodeNodeId("CreateSessionId");
        String _createClientName = decoder.decodeString("CreateClientName");
        DateTime _invocationCreationTime = decoder.decodeDateTime("InvocationCreationTime");
        DateTime _lastTransitionTime = decoder.decodeDateTime("LastTransitionTime");
        String _lastMethodCall = decoder.decodeString("LastMethodCall");
        NodeId _lastMethodSessionId = decoder.decodeNodeId("LastMethodSessionId");
        Argument[] _lastMethodInputArguments = decoder.decodeArray("LastMethodInputArguments", decoder::decodeSerializable, Argument.class);
        Argument[] _lastMethodOutputArguments = decoder.decodeArray("LastMethodOutputArguments", decoder::decodeSerializable, Argument.class);
        DateTime _lastMethodCallTime = decoder.decodeDateTime("LastMethodCallTime");
        StatusResult _lastMethodReturnStatus = decoder.decodeSerializable("LastMethodReturnStatus", StatusResult.class);
        return new ProgramDiagnosticDataType(_createSessionId, _createClientName, _invocationCreationTime, _lastTransitionTime, _lastMethodCall, _lastMethodSessionId, _lastMethodInputArguments, _lastMethodOutputArguments, _lastMethodCallTime, _lastMethodReturnStatus);
    }

    static {
        DelegateRegistry.registerEncoder(ProgramDiagnosticDataType::encode, ProgramDiagnosticDataType.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(ProgramDiagnosticDataType::decode, ProgramDiagnosticDataType.class, BinaryEncodingId, XmlEncodingId);
    }
}

