/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

@UaDataType(value="ParsingResult")
public class ParsingResult
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ParsingResult;
    public static final NodeId BinaryEncodingId = Identifiers.ParsingResult_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ParsingResult_Encoding_DefaultXml;
    protected final StatusCode _statusCode;
    protected final StatusCode[] _dataStatusCodes;
    protected final DiagnosticInfo[] _dataDiagnosticInfos;

    public ParsingResult() {
        this._statusCode = null;
        this._dataStatusCodes = null;
        this._dataDiagnosticInfos = null;
    }

    public ParsingResult(StatusCode _statusCode, StatusCode[] _dataStatusCodes, DiagnosticInfo[] _dataDiagnosticInfos) {
        this._statusCode = _statusCode;
        this._dataStatusCodes = _dataStatusCodes;
        this._dataDiagnosticInfos = _dataDiagnosticInfos;
    }

    public StatusCode getStatusCode() {
        return this._statusCode;
    }

    @Nullable
    public StatusCode[] getDataStatusCodes() {
        return this._dataStatusCodes;
    }

    @Nullable
    public DiagnosticInfo[] getDataDiagnosticInfos() {
        return this._dataDiagnosticInfos;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("StatusCode", (Object)this._statusCode).add("DataStatusCodes", (Object)this._dataStatusCodes).add("DataDiagnosticInfos", (Object)this._dataDiagnosticInfos).toString();
    }

    public static void encode(ParsingResult parsingResult, UaEncoder encoder) {
        encoder.encodeStatusCode("StatusCode", parsingResult._statusCode);
        encoder.encodeArray("DataStatusCodes", parsingResult._dataStatusCodes, encoder::encodeStatusCode);
        encoder.encodeArray("DataDiagnosticInfos", parsingResult._dataDiagnosticInfos, encoder::encodeDiagnosticInfo);
    }

    public static ParsingResult decode(UaDecoder decoder) {
        StatusCode _statusCode = decoder.decodeStatusCode("StatusCode");
        StatusCode[] _dataStatusCodes = decoder.decodeArray("DataStatusCodes", decoder::decodeStatusCode, StatusCode.class);
        DiagnosticInfo[] _dataDiagnosticInfos = decoder.decodeArray("DataDiagnosticInfos", decoder::decodeDiagnosticInfo, DiagnosticInfo.class);
        return new ParsingResult(_statusCode, _dataStatusCodes, _dataDiagnosticInfos);
    }

    static {
        DelegateRegistry.registerEncoder(ParsingResult::encode, ParsingResult.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(ParsingResult::decode, ParsingResult.class, BinaryEncodingId, XmlEncodingId);
    }
}

