/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

@UaDataType(value="OptionSet")
public class OptionSet
implements UaStructure {
    public static final NodeId TypeId = Identifiers.OptionSet;
    public static final NodeId BinaryEncodingId = Identifiers.OptionSet_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.OptionSet_Encoding_DefaultXml;
    protected final ByteString _value;
    protected final ByteString _validBits;

    public OptionSet() {
        this._value = null;
        this._validBits = null;
    }

    public OptionSet(ByteString _value, ByteString _validBits) {
        this._value = _value;
        this._validBits = _validBits;
    }

    public ByteString getValue() {
        return this._value;
    }

    public ByteString getValidBits() {
        return this._validBits;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Value", (Object)this._value).add("ValidBits", (Object)this._validBits).toString();
    }

    public static void encode(OptionSet optionSet, UaEncoder encoder) {
        encoder.encodeByteString("Value", optionSet._value);
        encoder.encodeByteString("ValidBits", optionSet._validBits);
    }

    public static OptionSet decode(UaDecoder decoder) {
        ByteString _value = decoder.decodeByteString("Value");
        ByteString _validBits = decoder.decodeByteString("ValidBits");
        return new OptionSet(_value, _validBits);
    }

    static {
        DelegateRegistry.registerEncoder(OptionSet::encode, OptionSet.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(OptionSet::decode, OptionSet.class, BinaryEncodingId, XmlEncodingId);
    }
}

