/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.HistoryUpdateType;

@UaDataType(value="ModificationInfo")
public class ModificationInfo
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ModificationInfo;
    public static final NodeId BinaryEncodingId = Identifiers.ModificationInfo_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ModificationInfo_Encoding_DefaultXml;
    protected final DateTime _modificationTime;
    protected final HistoryUpdateType _updateType;
    protected final String _userName;

    public ModificationInfo() {
        this._modificationTime = null;
        this._updateType = null;
        this._userName = null;
    }

    public ModificationInfo(DateTime _modificationTime, HistoryUpdateType _updateType, String _userName) {
        this._modificationTime = _modificationTime;
        this._updateType = _updateType;
        this._userName = _userName;
    }

    public DateTime getModificationTime() {
        return this._modificationTime;
    }

    public HistoryUpdateType getUpdateType() {
        return this._updateType;
    }

    public String getUserName() {
        return this._userName;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ModificationTime", (Object)this._modificationTime).add("UpdateType", (Object)this._updateType).add("UserName", (Object)this._userName).toString();
    }

    public static void encode(ModificationInfo modificationInfo, UaEncoder encoder) {
        encoder.encodeDateTime("ModificationTime", modificationInfo._modificationTime);
        encoder.encodeEnumeration("UpdateType", modificationInfo._updateType);
        encoder.encodeString("UserName", modificationInfo._userName);
    }

    public static ModificationInfo decode(UaDecoder decoder) {
        DateTime _modificationTime = decoder.decodeDateTime("ModificationTime");
        HistoryUpdateType _updateType = decoder.decodeEnumeration("UpdateType", HistoryUpdateType.class);
        String _userName = decoder.decodeString("UserName");
        return new ModificationInfo(_modificationTime, _updateType, _userName);
    }

    static {
        DelegateRegistry.registerEncoder(ModificationInfo::encode, ModificationInfo.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(ModificationInfo::decode, ModificationInfo.class, BinaryEncodingId, XmlEncodingId);
    }
}

