/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.FilterOperand;

@UaDataType(value="LiteralOperand")
public class LiteralOperand
extends FilterOperand {
    public static final NodeId TypeId = Identifiers.LiteralOperand;
    public static final NodeId BinaryEncodingId = Identifiers.LiteralOperand_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.LiteralOperand_Encoding_DefaultXml;
    protected final Variant _value;

    public LiteralOperand() {
        this._value = null;
    }

    public LiteralOperand(Variant _value) {
        this._value = _value;
    }

    public Variant getValue() {
        return this._value;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Value", (Object)this._value).toString();
    }

    public static void encode(LiteralOperand literalOperand, UaEncoder encoder) {
        encoder.encodeVariant("Value", literalOperand._value);
    }

    public static LiteralOperand decode(UaDecoder decoder) {
        Variant _value = decoder.decodeVariant("Value");
        return new LiteralOperand(_value);
    }

    static {
        DelegateRegistry.registerEncoder(LiteralOperand::encode, LiteralOperand.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(LiteralOperand::decode, LiteralOperand.class, BinaryEncodingId, XmlEncodingId);
    }
}

