/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryData;
import org.eclipse.milo.opcua.stack.core.types.structured.ModificationInfo;

@UaDataType(value="HistoryModifiedData")
public class HistoryModifiedData
extends HistoryData {
    public static final NodeId TypeId = Identifiers.HistoryModifiedData;
    public static final NodeId BinaryEncodingId = Identifiers.HistoryModifiedData_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.HistoryModifiedData_Encoding_DefaultXml;
    protected final DataValue[] _dataValues;
    protected final ModificationInfo[] _modificationInfos;

    public HistoryModifiedData() {
        this._dataValues = null;
        this._modificationInfos = null;
    }

    public HistoryModifiedData(DataValue[] _dataValues, ModificationInfo[] _modificationInfos) {
        this._dataValues = _dataValues;
        this._modificationInfos = _modificationInfos;
    }

    @Override
    @Nullable
    public DataValue[] getDataValues() {
        return this._dataValues;
    }

    @Nullable
    public ModificationInfo[] getModificationInfos() {
        return this._modificationInfos;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("DataValues", (Object)this._dataValues).add("ModificationInfos", (Object)this._modificationInfos).toString();
    }

    public static void encode(HistoryModifiedData historyModifiedData, UaEncoder encoder) {
        encoder.encodeArray("DataValues", historyModifiedData._dataValues, encoder::encodeDataValue);
        encoder.encodeArray("ModificationInfos", historyModifiedData._modificationInfos, encoder::encodeSerializable);
    }

    public static HistoryModifiedData decode(UaDecoder decoder) {
        DataValue[] _dataValues = decoder.decodeArray("DataValues", decoder::decodeDataValue, DataValue.class);
        ModificationInfo[] _modificationInfos = decoder.decodeArray("ModificationInfos", decoder::decodeSerializable, ModificationInfo.class);
        return new HistoryModifiedData(_dataValues, _modificationInfos);
    }

    static {
        DelegateRegistry.registerEncoder(HistoryModifiedData::encode, HistoryModifiedData.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(HistoryModifiedData::decode, HistoryModifiedData.class, BinaryEncodingId, XmlEncodingId);
    }
}

