/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

@UaDataType(value="GetEndpointsResponse")
public class GetEndpointsResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.GetEndpointsResponse;
    public static final NodeId BinaryEncodingId = Identifiers.GetEndpointsResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.GetEndpointsResponse_Encoding_DefaultXml;
    protected final ResponseHeader _responseHeader;
    protected final EndpointDescription[] _endpoints;

    public GetEndpointsResponse() {
        this._responseHeader = null;
        this._endpoints = null;
    }

    public GetEndpointsResponse(ResponseHeader _responseHeader, EndpointDescription[] _endpoints) {
        this._responseHeader = _responseHeader;
        this._endpoints = _endpoints;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this._responseHeader;
    }

    @Nullable
    public EndpointDescription[] getEndpoints() {
        return this._endpoints;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this._responseHeader).add("Endpoints", (Object)this._endpoints).toString();
    }

    public static void encode(GetEndpointsResponse getEndpointsResponse, UaEncoder encoder) {
        encoder.encodeSerializable("ResponseHeader", getEndpointsResponse._responseHeader != null ? getEndpointsResponse._responseHeader : new ResponseHeader());
        encoder.encodeArray("Endpoints", getEndpointsResponse._endpoints, encoder::encodeSerializable);
    }

    public static GetEndpointsResponse decode(UaDecoder decoder) {
        ResponseHeader _responseHeader = decoder.decodeSerializable("ResponseHeader", ResponseHeader.class);
        EndpointDescription[] _endpoints = decoder.decodeArray("Endpoints", decoder::decodeSerializable, EndpointDescription.class);
        return new GetEndpointsResponse(_responseHeader, _endpoints);
    }

    static {
        DelegateRegistry.registerEncoder(GetEndpointsResponse::encode, GetEndpointsResponse.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(GetEndpointsResponse::decode, GetEndpointsResponse.class, BinaryEncodingId, XmlEncodingId);
    }
}

