/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

@UaDataType(value="DeleteReferencesItem")
public class DeleteReferencesItem
implements UaStructure {
    public static final NodeId TypeId = Identifiers.DeleteReferencesItem;
    public static final NodeId BinaryEncodingId = Identifiers.DeleteReferencesItem_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.DeleteReferencesItem_Encoding_DefaultXml;
    protected final NodeId _sourceNodeId;
    protected final NodeId _referenceTypeId;
    protected final Boolean _isForward;
    protected final ExpandedNodeId _targetNodeId;
    protected final Boolean _deleteBidirectional;

    public DeleteReferencesItem() {
        this._sourceNodeId = null;
        this._referenceTypeId = null;
        this._isForward = null;
        this._targetNodeId = null;
        this._deleteBidirectional = null;
    }

    public DeleteReferencesItem(NodeId _sourceNodeId, NodeId _referenceTypeId, Boolean _isForward, ExpandedNodeId _targetNodeId, Boolean _deleteBidirectional) {
        this._sourceNodeId = _sourceNodeId;
        this._referenceTypeId = _referenceTypeId;
        this._isForward = _isForward;
        this._targetNodeId = _targetNodeId;
        this._deleteBidirectional = _deleteBidirectional;
    }

    public NodeId getSourceNodeId() {
        return this._sourceNodeId;
    }

    public NodeId getReferenceTypeId() {
        return this._referenceTypeId;
    }

    public Boolean getIsForward() {
        return this._isForward;
    }

    public ExpandedNodeId getTargetNodeId() {
        return this._targetNodeId;
    }

    public Boolean getDeleteBidirectional() {
        return this._deleteBidirectional;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("SourceNodeId", (Object)this._sourceNodeId).add("ReferenceTypeId", (Object)this._referenceTypeId).add("IsForward", (Object)this._isForward).add("TargetNodeId", (Object)this._targetNodeId).add("DeleteBidirectional", (Object)this._deleteBidirectional).toString();
    }

    public static void encode(DeleteReferencesItem deleteReferencesItem, UaEncoder encoder) {
        encoder.encodeNodeId("SourceNodeId", deleteReferencesItem._sourceNodeId);
        encoder.encodeNodeId("ReferenceTypeId", deleteReferencesItem._referenceTypeId);
        encoder.encodeBoolean("IsForward", deleteReferencesItem._isForward);
        encoder.encodeExpandedNodeId("TargetNodeId", deleteReferencesItem._targetNodeId);
        encoder.encodeBoolean("DeleteBidirectional", deleteReferencesItem._deleteBidirectional);
    }

    public static DeleteReferencesItem decode(UaDecoder decoder) {
        NodeId _sourceNodeId = decoder.decodeNodeId("SourceNodeId");
        NodeId _referenceTypeId = decoder.decodeNodeId("ReferenceTypeId");
        Boolean _isForward = decoder.decodeBoolean("IsForward");
        ExpandedNodeId _targetNodeId = decoder.decodeExpandedNodeId("TargetNodeId");
        Boolean _deleteBidirectional = decoder.decodeBoolean("DeleteBidirectional");
        return new DeleteReferencesItem(_sourceNodeId, _referenceTypeId, _isForward, _targetNodeId, _deleteBidirectional);
    }

    static {
        DelegateRegistry.registerEncoder(DeleteReferencesItem::encode, DeleteReferencesItem.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(DeleteReferencesItem::decode, DeleteReferencesItem.class, BinaryEncodingId, XmlEncodingId);
    }
}

