/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.FilterOperator;

@UaDataType(value="ContentFilterElement")
public class ContentFilterElement
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ContentFilterElement;
    public static final NodeId BinaryEncodingId = Identifiers.ContentFilterElement_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ContentFilterElement_Encoding_DefaultXml;
    protected final FilterOperator _filterOperator;
    protected final ExtensionObject[] _filterOperands;

    public ContentFilterElement() {
        this._filterOperator = null;
        this._filterOperands = null;
    }

    public ContentFilterElement(FilterOperator _filterOperator, ExtensionObject[] _filterOperands) {
        this._filterOperator = _filterOperator;
        this._filterOperands = _filterOperands;
    }

    public FilterOperator getFilterOperator() {
        return this._filterOperator;
    }

    @Nullable
    public ExtensionObject[] getFilterOperands() {
        return this._filterOperands;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("FilterOperator", (Object)this._filterOperator).add("FilterOperands", (Object)this._filterOperands).toString();
    }

    public static void encode(ContentFilterElement contentFilterElement, UaEncoder encoder) {
        encoder.encodeEnumeration("FilterOperator", contentFilterElement._filterOperator);
        encoder.encodeArray("FilterOperands", contentFilterElement._filterOperands, encoder::encodeExtensionObject);
    }

    public static ContentFilterElement decode(UaDecoder decoder) {
        FilterOperator _filterOperator = decoder.decodeEnumeration("FilterOperator", FilterOperator.class);
        ExtensionObject[] _filterOperands = decoder.decodeArray("FilterOperands", decoder::decodeExtensionObject, ExtensionObject.class);
        return new ContentFilterElement(_filterOperator, _filterOperands);
    }

    static {
        DelegateRegistry.registerEncoder(ContentFilterElement::encode, ContentFilterElement.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(ContentFilterElement::decode, ContentFilterElement.class, BinaryEncodingId, XmlEncodingId);
    }
}

