/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;

@UaDataType(value="CallMethodRequest")
public class CallMethodRequest
implements UaStructure {
    public static final NodeId TypeId = Identifiers.CallMethodRequest;
    public static final NodeId BinaryEncodingId = Identifiers.CallMethodRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.CallMethodRequest_Encoding_DefaultXml;
    protected final NodeId _objectId;
    protected final NodeId _methodId;
    protected final Variant[] _inputArguments;

    public CallMethodRequest() {
        this._objectId = null;
        this._methodId = null;
        this._inputArguments = null;
    }

    public CallMethodRequest(NodeId _objectId, NodeId _methodId, Variant[] _inputArguments) {
        this._objectId = _objectId;
        this._methodId = _methodId;
        this._inputArguments = _inputArguments;
    }

    public NodeId getObjectId() {
        return this._objectId;
    }

    public NodeId getMethodId() {
        return this._methodId;
    }

    @Nullable
    public Variant[] getInputArguments() {
        return this._inputArguments;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ObjectId", (Object)this._objectId).add("MethodId", (Object)this._methodId).add("InputArguments", (Object)this._inputArguments).toString();
    }

    public static void encode(CallMethodRequest callMethodRequest, UaEncoder encoder) {
        encoder.encodeNodeId("ObjectId", callMethodRequest._objectId);
        encoder.encodeNodeId("MethodId", callMethodRequest._methodId);
        encoder.encodeArray("InputArguments", callMethodRequest._inputArguments, encoder::encodeVariant);
    }

    public static CallMethodRequest decode(UaDecoder decoder) {
        NodeId _objectId = decoder.decodeNodeId("ObjectId");
        NodeId _methodId = decoder.decodeNodeId("MethodId");
        Variant[] _inputArguments = decoder.decodeArray("InputArguments", decoder::decodeVariant, Variant.class);
        return new CallMethodRequest(_objectId, _methodId, _inputArguments);
    }

    static {
        DelegateRegistry.registerEncoder(CallMethodRequest::encode, CallMethodRequest.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(CallMethodRequest::decode, CallMethodRequest.class, BinaryEncodingId, XmlEncodingId);
    }
}

