/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

@UaDataType(value="BrowseNextRequest")
public class BrowseNextRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.BrowseNextRequest;
    public static final NodeId BinaryEncodingId = Identifiers.BrowseNextRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.BrowseNextRequest_Encoding_DefaultXml;
    protected final RequestHeader _requestHeader;
    protected final Boolean _releaseContinuationPoints;
    protected final ByteString[] _continuationPoints;

    public BrowseNextRequest() {
        this._requestHeader = null;
        this._releaseContinuationPoints = null;
        this._continuationPoints = null;
    }

    public BrowseNextRequest(RequestHeader _requestHeader, Boolean _releaseContinuationPoints, ByteString[] _continuationPoints) {
        this._requestHeader = _requestHeader;
        this._releaseContinuationPoints = _releaseContinuationPoints;
        this._continuationPoints = _continuationPoints;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this._requestHeader;
    }

    public Boolean getReleaseContinuationPoints() {
        return this._releaseContinuationPoints;
    }

    @Nullable
    public ByteString[] getContinuationPoints() {
        return this._continuationPoints;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this._requestHeader).add("ReleaseContinuationPoints", (Object)this._releaseContinuationPoints).add("ContinuationPoints", (Object)this._continuationPoints).toString();
    }

    public static void encode(BrowseNextRequest browseNextRequest, UaEncoder encoder) {
        encoder.encodeSerializable("RequestHeader", browseNextRequest._requestHeader != null ? browseNextRequest._requestHeader : new RequestHeader());
        encoder.encodeBoolean("ReleaseContinuationPoints", browseNextRequest._releaseContinuationPoints);
        encoder.encodeArray("ContinuationPoints", browseNextRequest._continuationPoints, encoder::encodeByteString);
    }

    public static BrowseNextRequest decode(UaDecoder decoder) {
        RequestHeader _requestHeader = decoder.decodeSerializable("RequestHeader", RequestHeader.class);
        Boolean _releaseContinuationPoints = decoder.decodeBoolean("ReleaseContinuationPoints");
        ByteString[] _continuationPoints = decoder.decodeArray("ContinuationPoints", decoder::decodeByteString, ByteString.class);
        return new BrowseNextRequest(_requestHeader, _releaseContinuationPoints, _continuationPoints);
    }

    static {
        DelegateRegistry.registerEncoder(BrowseNextRequest::encode, BrowseNextRequest.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(BrowseNextRequest::decode, BrowseNextRequest.class, BinaryEncodingId, XmlEncodingId);
    }
}

