/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;

@UaDataType(value="BrowseDescription")
public class BrowseDescription
implements UaStructure {
    public static final NodeId TypeId = Identifiers.BrowseDescription;
    public static final NodeId BinaryEncodingId = Identifiers.BrowseDescription_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.BrowseDescription_Encoding_DefaultXml;
    protected final NodeId _nodeId;
    protected final BrowseDirection _browseDirection;
    protected final NodeId _referenceTypeId;
    protected final Boolean _includeSubtypes;
    protected final UInteger _nodeClassMask;
    protected final UInteger _resultMask;

    public BrowseDescription() {
        this._nodeId = null;
        this._browseDirection = null;
        this._referenceTypeId = null;
        this._includeSubtypes = null;
        this._nodeClassMask = null;
        this._resultMask = null;
    }

    public BrowseDescription(NodeId _nodeId, BrowseDirection _browseDirection, NodeId _referenceTypeId, Boolean _includeSubtypes, UInteger _nodeClassMask, UInteger _resultMask) {
        this._nodeId = _nodeId;
        this._browseDirection = _browseDirection;
        this._referenceTypeId = _referenceTypeId;
        this._includeSubtypes = _includeSubtypes;
        this._nodeClassMask = _nodeClassMask;
        this._resultMask = _resultMask;
    }

    public NodeId getNodeId() {
        return this._nodeId;
    }

    public BrowseDirection getBrowseDirection() {
        return this._browseDirection;
    }

    public NodeId getReferenceTypeId() {
        return this._referenceTypeId;
    }

    public Boolean getIncludeSubtypes() {
        return this._includeSubtypes;
    }

    public UInteger getNodeClassMask() {
        return this._nodeClassMask;
    }

    public UInteger getResultMask() {
        return this._resultMask;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("NodeId", (Object)this._nodeId).add("BrowseDirection", (Object)this._browseDirection).add("ReferenceTypeId", (Object)this._referenceTypeId).add("IncludeSubtypes", (Object)this._includeSubtypes).add("NodeClassMask", (Object)this._nodeClassMask).add("ResultMask", (Object)this._resultMask).toString();
    }

    public static void encode(BrowseDescription browseDescription, UaEncoder encoder) {
        encoder.encodeNodeId("NodeId", browseDescription._nodeId);
        encoder.encodeEnumeration("BrowseDirection", browseDescription._browseDirection);
        encoder.encodeNodeId("ReferenceTypeId", browseDescription._referenceTypeId);
        encoder.encodeBoolean("IncludeSubtypes", browseDescription._includeSubtypes);
        encoder.encodeUInt32("NodeClassMask", browseDescription._nodeClassMask);
        encoder.encodeUInt32("ResultMask", browseDescription._resultMask);
    }

    public static BrowseDescription decode(UaDecoder decoder) {
        NodeId _nodeId = decoder.decodeNodeId("NodeId");
        BrowseDirection _browseDirection = decoder.decodeEnumeration("BrowseDirection", BrowseDirection.class);
        NodeId _referenceTypeId = decoder.decodeNodeId("ReferenceTypeId");
        Boolean _includeSubtypes = decoder.decodeBoolean("IncludeSubtypes");
        UInteger _nodeClassMask = decoder.decodeUInt32("NodeClassMask");
        UInteger _resultMask = decoder.decodeUInt32("ResultMask");
        return new BrowseDescription(_nodeId, _browseDirection, _referenceTypeId, _includeSubtypes, _nodeClassMask, _resultMask);
    }

    static {
        DelegateRegistry.registerEncoder(BrowseDescription::encode, BrowseDescription.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(BrowseDescription::decode, BrowseDescription.class, BinaryEncodingId, XmlEncodingId);
    }
}

