/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.AxisScaleEnumeration;
import org.eclipse.milo.opcua.stack.core.types.structured.EUInformation;
import org.eclipse.milo.opcua.stack.core.types.structured.Range;

@UaDataType(value="AxisInformation")
public class AxisInformation
implements UaStructure {
    public static final NodeId TypeId = Identifiers.AxisInformation;
    public static final NodeId BinaryEncodingId = Identifiers.AxisInformation_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.AxisInformation_Encoding_DefaultXml;
    protected final EUInformation _engineeringUnits;
    protected final Range _eURange;
    protected final LocalizedText _title;
    protected final AxisScaleEnumeration _axisScaleType;
    protected final Double[] _axisSteps;

    public AxisInformation() {
        this._engineeringUnits = null;
        this._eURange = null;
        this._title = null;
        this._axisScaleType = null;
        this._axisSteps = null;
    }

    public AxisInformation(EUInformation _engineeringUnits, Range _eURange, LocalizedText _title, AxisScaleEnumeration _axisScaleType, Double[] _axisSteps) {
        this._engineeringUnits = _engineeringUnits;
        this._eURange = _eURange;
        this._title = _title;
        this._axisScaleType = _axisScaleType;
        this._axisSteps = _axisSteps;
    }

    public EUInformation getEngineeringUnits() {
        return this._engineeringUnits;
    }

    public Range getEURange() {
        return this._eURange;
    }

    public LocalizedText getTitle() {
        return this._title;
    }

    public AxisScaleEnumeration getAxisScaleType() {
        return this._axisScaleType;
    }

    @Nullable
    public Double[] getAxisSteps() {
        return this._axisSteps;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("EngineeringUnits", (Object)this._engineeringUnits).add("EURange", (Object)this._eURange).add("Title", (Object)this._title).add("AxisScaleType", (Object)this._axisScaleType).add("AxisSteps", (Object)this._axisSteps).toString();
    }

    public static void encode(AxisInformation axisInformation, UaEncoder encoder) {
        encoder.encodeSerializable("EngineeringUnits", axisInformation._engineeringUnits != null ? axisInformation._engineeringUnits : new EUInformation());
        encoder.encodeSerializable("EURange", axisInformation._eURange != null ? axisInformation._eURange : new Range());
        encoder.encodeLocalizedText("Title", axisInformation._title);
        encoder.encodeEnumeration("AxisScaleType", axisInformation._axisScaleType);
        encoder.encodeArray("AxisSteps", axisInformation._axisSteps, encoder::encodeDouble);
    }

    public static AxisInformation decode(UaDecoder decoder) {
        EUInformation _engineeringUnits = decoder.decodeSerializable("EngineeringUnits", EUInformation.class);
        Range _eURange = decoder.decodeSerializable("EURange", Range.class);
        LocalizedText _title = decoder.decodeLocalizedText("Title");
        AxisScaleEnumeration _axisScaleType = decoder.decodeEnumeration("AxisScaleType", AxisScaleEnumeration.class);
        Double[] _axisSteps = decoder.decodeArray("AxisSteps", decoder::decodeDouble, Double.class);
        return new AxisInformation(_engineeringUnits, _eURange, _title, _axisScaleType, _axisSteps);
    }

    static {
        DelegateRegistry.registerEncoder(AxisInformation::encode, AxisInformation.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(AxisInformation::decode, AxisInformation.class, BinaryEncodingId, XmlEncodingId);
    }
}

