/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public enum UserTokenType implements UaEnumeration
{
    Anonymous(0),
    UserName(1),
    Certificate(2),
    IssuedToken(3),
    Kerberos(4);

    private final int value;
    private static final ImmutableMap<Integer, UserTokenType> VALUES;

    private UserTokenType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static UserTokenType from(Integer value) {
        if (value == null) {
            return null;
        }
        return (UserTokenType)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(UserTokenType userTokenType, UaEncoder encoder) {
        encoder.encodeInt32(null, userTokenType.getValue());
    }

    public static UserTokenType decode(UaDecoder decoder) {
        int value = decoder.decodeInt32(null);
        return (UserTokenType)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (UserTokenType e : UserTokenType.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
        DelegateRegistry.registerEncoder(UserTokenType::encode, UserTokenType.class, new NodeId[0]);
        DelegateRegistry.registerDecoder(UserTokenType::decode, UserTokenType.class, new NodeId[0]);
    }
}

