/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public enum SecurityTokenRequestType implements UaEnumeration
{
    Issue(0),
    Renew(1);

    private final int value;
    private static final ImmutableMap<Integer, SecurityTokenRequestType> VALUES;

    private SecurityTokenRequestType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static SecurityTokenRequestType from(Integer value) {
        if (value == null) {
            return null;
        }
        return (SecurityTokenRequestType)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(SecurityTokenRequestType securityTokenRequestType, UaEncoder encoder) {
        encoder.encodeInt32(null, securityTokenRequestType.getValue());
    }

    public static SecurityTokenRequestType decode(UaDecoder decoder) {
        int value = decoder.decodeInt32(null);
        return (SecurityTokenRequestType)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SecurityTokenRequestType e : SecurityTokenRequestType.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
        DelegateRegistry.registerEncoder(SecurityTokenRequestType::encode, SecurityTokenRequestType.class, new NodeId[0]);
        DelegateRegistry.registerDecoder(SecurityTokenRequestType::decode, SecurityTokenRequestType.class, new NodeId[0]);
    }
}

