/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public enum NodeClass implements UaEnumeration
{
    Unspecified(0),
    Object(1),
    Variable(2),
    Method(4),
    ObjectType(8),
    VariableType(16),
    ReferenceType(32),
    DataType(64),
    View(128);

    private final int value;
    private static final ImmutableMap<Integer, NodeClass> VALUES;

    private NodeClass(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static NodeClass from(Integer value) {
        if (value == null) {
            return null;
        }
        return (NodeClass)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(NodeClass nodeClass, UaEncoder encoder) {
        encoder.encodeInt32(null, nodeClass.getValue());
    }

    public static NodeClass decode(UaDecoder decoder) {
        int value = decoder.decodeInt32(null);
        return (NodeClass)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (NodeClass e : NodeClass.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
        DelegateRegistry.registerEncoder(NodeClass::encode, NodeClass.class, new NodeId[0]);
        DelegateRegistry.registerDecoder(NodeClass::decode, NodeClass.class, new NodeId[0]);
    }
}

