/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization.xml;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Calendar;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.xml.bind.DatatypeConverter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.UaSerializable;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jooq.lambda.Unchecked;

public class XmlEncoder
implements UaEncoder {
    private final Calendar calendar = Calendar.getInstance();
    private final XMLOutputFactory factory = XMLOutputFactory.newFactory();
    private volatile XMLStreamWriter streamWriter;

    public XmlEncoder() {
    }

    public XmlEncoder(OutputStream outputStream) throws XMLStreamException {
        this.setOutput(outputStream);
    }

    public XmlEncoder(Writer writer) throws XMLStreamException {
        this.setOutput(writer);
    }

    public XmlEncoder setOutput(OutputStream outputStream) throws XMLStreamException {
        this.streamWriter = this.factory.createXMLStreamWriter(outputStream);
        this.streamWriter.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.streamWriter.setPrefix("tns", "http://opcfoundation.org/UA/2008/02/Types.xsd");
        return this;
    }

    public XmlEncoder setOutput(Writer writer) throws XMLStreamException {
        this.streamWriter = this.factory.createXMLStreamWriter(writer);
        this.streamWriter.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.streamWriter.setPrefix("tns", "http://opcfoundation.org/UA/2008/02/Types.xsd");
        return this;
    }

    @Override
    public void encodeBoolean(String field, Boolean value) {
        if (value == null) {
            value = false;
        }
        this.writeValue(field, value.toString());
    }

    @Override
    public void encodeSByte(String field, Byte value) {
        if (value == null) {
            value = 0;
        }
        this.writeValue(field, value.toString());
    }

    @Override
    public void encodeInt16(String field, Short value) {
        if (value == null) {
            value = 0;
        }
        this.writeValue(field, value.toString());
    }

    @Override
    public void encodeInt32(String field, Integer value) {
        if (value == null) {
            value = 0;
        }
        this.writeValue(field, value.toString());
    }

    @Override
    public void encodeInt64(String field, Long value) {
        if (value == null) {
            value = 0L;
        }
        this.writeValue(field, value.toString());
    }

    @Override
    public void encodeByte(String field, UByte value) throws UaSerializationException {
        if (value == null) {
            value = Unsigned.ubyte(0);
        }
        this.writeValue(field, value.toString());
    }

    @Override
    public void encodeUInt16(String field, UShort value) throws UaSerializationException {
        if (value == null) {
            value = Unsigned.ushort(0);
        }
        this.writeValue(field, value.toString());
    }

    @Override
    public void encodeUInt32(String field, UInteger value) throws UaSerializationException {
        if (value == null) {
            value = Unsigned.uint(0);
        }
        this.writeValue(field, value.toString());
    }

    @Override
    public void encodeUInt64(String field, ULong value) throws UaSerializationException {
        if (value == null) {
            value = Unsigned.ulong(0L);
        }
        this.writeValue(field, value.toString());
    }

    @Override
    public void encodeFloat(String field, Float value) {
        if (value == null) {
            value = Float.valueOf(0.0f);
        }
        this.writeValue(field, value.toString());
    }

    @Override
    public void encodeDouble(String field, Double value) {
        if (value == null) {
            value = 0.0;
        }
        this.writeValue(field, value.toString());
    }

    @Override
    public void encodeString(String field, String value) {
        if (value == null) {
            value = "";
        }
        this.writeValue(field, value);
    }

    @Override
    public void encodeDateTime(String field, DateTime value) {
        if (value == null) {
            value = DateTime.MIN_VALUE;
        }
        this.calendar.setTime(value.getJavaDate());
        this.writeValue(field, DatatypeConverter.printDateTime((Calendar)this.calendar));
    }

    @Override
    public void encodeGuid(String field, UUID value) {
        if (value != null) {
            this.write(field, Unchecked.consumer(w -> {
                w.writeStartElement("String");
                w.writeCharacters(value.toString());
                w.writeEndElement();
            }));
        } else if (field != null) {
            try {
                this.streamWriter.writeEmptyElement(field);
            }
            catch (XMLStreamException e) {
                throw new UaSerializationException(0x80060000L, (Throwable)e);
            }
        }
    }

    @Override
    public void encodeByteString(String field, ByteString value) {
        if (value == null) {
            value = ByteString.NULL_VALUE;
        }
        if (value.isNotNull()) {
            byte[] bs = value.bytes();
            this.writeValue(field, DatatypeConverter.printBase64Binary((byte[])bs));
        } else {
            this.writeNilValue(field, "ByteString");
        }
    }

    @Override
    public void encodeXmlElement(String field, XmlElement value) {
        if (value == null) {
            value = XmlElement.of("");
        }
        this.writeValue(field, value.getFragment());
    }

    @Override
    public void encodeNodeId(String field, NodeId value) {
        if (value != null) {
            this.write(field, Unchecked.consumer(w -> {
                w.writeStartElement("Identifier");
                w.writeCharacters(value.toParseableString());
                w.writeEndElement();
            }));
        } else if (field != null) {
            try {
                this.streamWriter.writeEmptyElement(field);
            }
            catch (XMLStreamException e) {
                throw new UaSerializationException(0x80060000L, (Throwable)e);
            }
        }
    }

    @Override
    public void encodeExpandedNodeId(String field, ExpandedNodeId value) {
        if (value != null) {
            this.write(field, Unchecked.consumer(w -> {
                w.writeStartElement("Identifier");
                w.writeCharacters(value.toParseableString());
                w.writeEndElement();
            }));
        } else if (field != null) {
            try {
                this.streamWriter.writeEmptyElement(field);
            }
            catch (XMLStreamException e) {
                throw new UaSerializationException(0x80060000L, (Throwable)e);
            }
        }
    }

    @Override
    public void encodeStatusCode(String field, StatusCode value) {
        if (value != null) {
            this.write(field, Unchecked.consumer(w -> this.encodeStatusCode("Identifier", value)));
        } else if (field != null) {
            try {
                this.streamWriter.writeEmptyElement(field);
            }
            catch (XMLStreamException e) {
                throw new UaSerializationException(0x80060000L, (Throwable)e);
            }
        }
    }

    @Override
    public void encodeQualifiedName(String field, QualifiedName value) {
        if (value != null) {
            this.write(field, Unchecked.consumer(w -> {
                this.encodeUInt16("NamespaceIndex", value.getNamespaceIndex());
                this.encodeString("Name", value.getName());
            }));
        } else if (field != null) {
            try {
                this.streamWriter.writeEmptyElement(field);
            }
            catch (XMLStreamException e) {
                throw new UaSerializationException(0x80060000L, (Throwable)e);
            }
        }
    }

    @Override
    public void encodeLocalizedText(String field, LocalizedText value) {
        if (value != null) {
            this.write(field, Unchecked.consumer(w -> {
                this.encodeString("Locale", value.getLocale());
                this.encodeString("Text", value.getText());
            }));
        } else if (field != null) {
            try {
                this.streamWriter.writeEmptyElement(field);
            }
            catch (XMLStreamException e) {
                throw new UaSerializationException(0x80060000L, (Throwable)e);
            }
        }
    }

    @Override
    public void encodeExtensionObject(String field, ExtensionObject value) {
        if (value != null) {
            this.write(field, Unchecked.consumer(w -> {
                this.encodeNodeId("TypeId", value.getEncodingTypeId());
                Object object = value.getEncoded();
                if (object instanceof UaSerializable) {
                    UaSerializable serializable = (UaSerializable)object;
                    this.encodeSerializable("Body", serializable);
                } else if (object instanceof ByteString) {
                    ByteString byteString = (ByteString)object;
                    this.streamWriter.writeStartElement("Body");
                    this.encodeByteString("ByteString", byteString);
                    this.streamWriter.writeEndElement();
                } else if (object instanceof XmlElement) {
                    XmlElement xmlElement = (XmlElement)object;
                    this.encodeXmlElement("Body", xmlElement);
                }
            }));
        }
    }

    @Override
    public void encodeDataValue(String field, DataValue value) {
    }

    @Override
    public void encodeVariant(String field, Variant value) {
    }

    @Override
    public void encodeDiagnosticInfo(String field, DiagnosticInfo value) {
    }

    @Override
    public <T extends UaStructure> void encodeMessage(String field, T message) {
    }

    @Override
    public <T extends UaEnumeration> void encodeEnumeration(String field, T value) throws UaSerializationException {
        String s = value == null ? null : value.toString() + "_" + value.getValue();
        this.writeValue(field, s != null ? s : "");
    }

    @Override
    public <T extends UaSerializable> void encodeSerializable(String field, T value) {
    }

    @Override
    public <T> void encodeArray(String field, T[] values, BiConsumer<String, T> encoder) {
    }

    private void write(String field, Consumer<XMLStreamWriter> c) {
        try {
            if (field != null) {
                this.streamWriter.writeStartElement(field);
            }
            c.accept(this.streamWriter);
            if (field != null) {
                this.streamWriter.writeEndElement();
            }
        }
        catch (Throwable t) {
            throw new UaSerializationException(0x80060000L, t);
        }
    }

    private void writeValue(String field, @Nonnull String value) {
        this.write(field, Unchecked.consumer(w -> w.writeCharacters(value)));
    }

    private void writeNilValue(String field, String name) {
        this.write(field, Unchecked.consumer(w -> {
            w.writeEmptyElement(name);
            w.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
        }));
    }
}

