/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization.xml;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.xml.bind.DatatypeConverter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.UaSerializable;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

public class XmlDecoder
implements UaDecoder {
    private final XMLInputFactory factory = XMLInputFactory.newFactory();
    private volatile XMLStreamReader streamReader;

    public XmlDecoder() {
    }

    public XmlDecoder(InputStream inputStream) throws XMLStreamException {
        this.setInput(inputStream);
    }

    public XmlDecoder(Reader reader) throws XMLStreamException {
        this.setInput(reader);
    }

    public XmlDecoder setInput(InputStream inputStream) throws XMLStreamException {
        this.streamReader = this.factory.createXMLStreamReader(inputStream);
        return this;
    }

    public XmlDecoder setInput(Reader reader) throws XMLStreamException {
        this.streamReader = this.factory.createXMLStreamReader(reader);
        return this;
    }

    public void skipElement() throws XMLStreamException {
        this.streamReader.nextTag();
    }

    @Override
    public Boolean decodeBoolean(String field) throws UaSerializationException {
        return this.parseElement(field, Boolean::valueOf);
    }

    @Override
    public Byte decodeSByte(String field) throws UaSerializationException {
        return this.parseElement(field, Byte::parseByte);
    }

    @Override
    public Short decodeInt16(String field) throws UaSerializationException {
        return this.parseElement(field, Short::parseShort);
    }

    @Override
    public Integer decodeInt32(String field) throws UaSerializationException {
        return this.parseElement(field, Integer::parseInt);
    }

    @Override
    public Long decodeInt64(String field) throws UaSerializationException {
        return this.parseElement(field, Long::parseLong);
    }

    @Override
    public UByte decodeByte(String field) throws UaSerializationException {
        return this.parseElement(field, s -> Unsigned.ubyte(Short.parseShort(s)));
    }

    @Override
    public UShort decodeUInt16(String field) throws UaSerializationException {
        return this.parseElement(field, s -> Unsigned.ushort(Integer.parseInt(s)));
    }

    @Override
    public UInteger decodeUInt32(String field) throws UaSerializationException {
        return this.parseElement(field, s -> Unsigned.uint(Long.parseLong(s)));
    }

    @Override
    public ULong decodeUInt64(String field) throws UaSerializationException {
        return this.parseElement(field, s -> Unsigned.ulong(Long.parseUnsignedLong(s)));
    }

    @Override
    public Float decodeFloat(String field) throws UaSerializationException {
        return this.parseElement(field, Float::parseFloat);
    }

    @Override
    public Double decodeDouble(String field) throws UaSerializationException {
        return this.parseElement(field, Double::parseDouble);
    }

    @Override
    public String decodeString(String field) throws UaSerializationException {
        return this.parseElement(field, content -> content);
    }

    @Override
    public DateTime decodeDateTime(String field) throws UaSerializationException {
        return this.parseElement(field, content -> {
            Calendar calendar = DatatypeConverter.parseDateTime((String)content);
            return new DateTime(calendar.getTime());
        });
    }

    @Override
    public UUID decodeGuid(String field) throws UaSerializationException {
        UUID uuid;
        this.requireNextStartElement(field);
        if (this.nextStartElement("String")) {
            try {
                String text = this.streamReader.getElementText();
                uuid = UUID.fromString(text);
                this.requireNextEndElement(field);
            }
            catch (XMLStreamException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
        } else {
            uuid = new UUID(0L, 0L);
            this.requireCurrentElement(field);
        }
        return uuid;
    }

    @Override
    public ByteString decodeByteString(String field) throws UaSerializationException {
        return this.parseNillableElement(field, content -> {
            if (content != null) {
                byte[] bs = DatatypeConverter.parseBase64Binary((String)content);
                return ByteString.of(bs);
            }
            return ByteString.NULL_VALUE;
        });
    }

    @Override
    public XmlElement decodeXmlElement(String field) {
        return null;
    }

    @Override
    public NodeId decodeNodeId(String field) throws UaSerializationException {
        NodeId nodeId;
        this.requireNextStartElement(field);
        if (this.nextStartElement("Identifier")) {
            try {
                String text = this.streamReader.getElementText();
                nodeId = NodeId.parse(text);
                this.requireNextEndElement(field);
            }
            catch (XMLStreamException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
        } else {
            nodeId = NodeId.NULL_VALUE;
        }
        return nodeId;
    }

    @Override
    public ExpandedNodeId decodeExpandedNodeId(String field) {
        ExpandedNodeId nodeId;
        this.requireNextStartElement(field);
        if (this.nextStartElement("Identifier")) {
            try {
                String text = this.streamReader.getElementText();
                nodeId = ExpandedNodeId.parse(text);
                this.requireNextEndElement(field);
            }
            catch (XMLStreamException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
        } else {
            nodeId = ExpandedNodeId.NULL_VALUE;
        }
        return nodeId;
    }

    @Override
    public StatusCode decodeStatusCode(String field) {
        if (this.nextStartElement(field)) {
            UInteger value = Unsigned.uint(0);
            if (this.nextStartElement("Code")) {
                value = this.decodeUInt32(null);
                this.requireNextEndElement("Code");
            }
            this.requireNextEndElement(field);
            return new StatusCode(value);
        }
        return new StatusCode(0);
    }

    @Override
    public QualifiedName decodeQualifiedName(String field) {
        if (this.nextStartElement(field)) {
            UShort namespaceIndex = Unsigned.ushort(0);
            String name = "";
            if (this.nextStartElement("NamespaceIndex")) {
                namespaceIndex = this.decodeUInt16(null);
                this.requireNextEndElement("NamespaceIndex");
            }
            if (this.nextStartElement("Name")) {
                name = this.decodeString(null);
                this.requireNextEndElement("Name");
            }
            this.requireNextEndElement(field);
            return new QualifiedName(namespaceIndex, name);
        }
        return QualifiedName.NULL_VALUE;
    }

    @Override
    public LocalizedText decodeLocalizedText(String field) {
        if (this.nextStartElement(field)) {
            String locale = LocalizedText.NULL_VALUE.getLocale();
            String text = LocalizedText.NULL_VALUE.getText();
            if (this.nextStartElement("Locale")) {
                locale = this.readElementText().orElse(LocalizedText.NULL_VALUE.getLocale());
            }
            if (this.nextStartElement("Text")) {
                text = this.readElementText().orElse(LocalizedText.NULL_VALUE.getText());
            }
            this.requireNextEndElement(field);
            return new LocalizedText(locale, text);
        }
        return LocalizedText.NULL_VALUE;
    }

    @Override
    public ExtensionObject decodeExtensionObject(String field) {
        if (this.nextStartElement(field)) {
            NodeId encodingTypeId = NodeId.NULL_VALUE;
            Object body = null;
            if (this.nextStartElement("TypeId")) {
                encodingTypeId = this.decodeNodeId(null);
                this.requireNextEndElement("TypeId");
            }
            if (this.nextStartElement("Body")) {
                try {
                    body = this.decodeExtensionObjectBody();
                }
                catch (XMLStreamException e) {
                    throw new UaSerializationException(0x80070000L, (Throwable)e);
                }
                this.requireNextEndElement("Body");
            }
            this.requireNextEndElement(field);
            if (body instanceof XmlElement) {
                return new ExtensionObject((XmlElement)body, encodingTypeId);
            }
            if (body instanceof ByteString) {
                return new ExtensionObject((ByteString)body, encodingTypeId);
            }
            throw new UaSerializationException(0x80070000L, "unrecognized ExtensionObject body: " + body);
        }
        return new ExtensionObject(ByteString.NULL_VALUE, NodeId.NULL_VALUE);
    }

    private Object decodeExtensionObjectBody() throws XMLStreamException {
        String bodyStartElement = this.getNextStartElement();
        if ("ByteString".equals(bodyStartElement)) {
            ByteString byteString = this.decodeByteString(null);
            this.requireNextEndElement("ByteString");
            return byteString;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<").append(bodyStartElement).append(">");
        while (this.streamReader.hasNext()) {
            this.streamReader.next();
            if (this.streamReader.hasText()) {
                String text = this.streamReader.getText();
                builder.append(text);
                continue;
            }
            if (!this.streamReader.hasName()) continue;
            String name = this.streamReader.getLocalName();
            builder.append("<");
            if (this.streamReader.isEndElement()) {
                builder.append("/");
            }
            builder.append(name).append(">");
            if (!bodyStartElement.equals(name)) continue;
            break;
        }
        String bodyXml = builder.toString();
        return new XmlElement(bodyXml);
    }

    @Override
    public DataValue decodeDataValue(String field) {
        if (this.nextStartElement(field)) {
            Variant value = Variant.NULL_VALUE;
            StatusCode statusCode = new StatusCode(0);
            DateTime sourceTimestamp = DateTime.MIN_VALUE;
            UShort sourcePicoseconds = Unsigned.ushort(0);
            DateTime serverTimestamp = DateTime.MIN_VALUE;
            UShort serverPicoseconds = Unsigned.ushort(0);
            if (this.nextStartElement("Value")) {
                value = this.decodeVariant(null);
                this.requireNextEndElement("Value");
            }
            if (this.nextStartElement("StatusCode")) {
                statusCode = this.decodeStatusCode(null);
                this.requireNextEndElement("StatusCode");
            }
            if (this.nextStartElement("SourceTimestamp")) {
                sourceTimestamp = this.decodeDateTime(null);
                this.requireNextEndElement("SourceTimestamp");
            }
            if (this.nextStartElement("SourcePicoseconds")) {
                sourcePicoseconds = this.decodeUInt16(null);
                this.requireNextEndElement("SourcePicoseconds");
            }
            if (this.nextStartElement("ServerTimestamp")) {
                serverTimestamp = this.decodeDateTime(null);
                this.requireNextEndElement("ServerTimestamp");
            }
            if (this.nextStartElement("ServerPicoseconds")) {
                serverPicoseconds = this.decodeUInt16(null);
                this.requireNextEndElement("ServerPicoseconds");
            }
            this.requireNextEndElement(field);
            return new DataValue(value, statusCode, sourceTimestamp, sourcePicoseconds, serverTimestamp, serverPicoseconds);
        }
        return new DataValue(Variant.NULL_VALUE);
    }

    @Override
    public Variant decodeVariant(String field) {
        if (this.nextStartElement(field)) {
            Object value = null;
            if (this.nextStartElement("Value")) {
                try {
                    value = this.decodeVariantValue();
                }
                catch (XMLStreamException e) {
                    throw new UaSerializationException(0x80070000L, (Throwable)e);
                }
                this.requireNextEndElement("Value");
            }
            this.requireNextEndElement(field);
            return new Variant(value);
        }
        return Variant.NULL_VALUE;
    }

    public Object decodeVariantValue() throws XMLStreamException {
        String valueStartElement = this.getNextStartElement();
        if (valueStartElement.startsWith("ListOf")) {
            String valueType = valueStartElement.substring(6);
            ArrayList<Object> values = new ArrayList<Object>();
            while (this.nextStartElement(valueType)) {
                values.add(this.decodeBuiltinType(valueType));
                this.requireNextEndElement(valueType);
            }
            if (values.size() > 0) {
                Class<?> c = values.get(0).getClass();
                Object a = Array.newInstance(c, values.size());
                for (int i = 0; i < values.size(); ++i) {
                    Array.set(a, i, values.get(i));
                }
                return a;
            }
            return null;
        }
        Object value = this.decodeBuiltinType(valueStartElement);
        this.requireNextEndElement(valueStartElement);
        return value;
    }

    private Object decodeBuiltinType(String type) throws UaSerializationException {
        switch (type) {
            case "Boolean": {
                return this.decodeBoolean(null);
            }
            case "SByte": {
                return this.decodeSByte(null);
            }
            case "Byte": {
                return this.decodeByte(null);
            }
            case "Int16": {
                return this.decodeInt16(null);
            }
            case "UInt16": {
                return this.decodeUInt16(null);
            }
            case "Int32": {
                return this.decodeInt32(null);
            }
            case "UInt32": {
                return this.decodeUInt32(null);
            }
            case "Int64": {
                return this.decodeInt64(null);
            }
            case "UInt64": {
                return this.decodeUInt64(null);
            }
            case "Float": {
                return this.decodeFloat(null);
            }
            case "Double": {
                return this.decodeDouble(null);
            }
            case "String": {
                return this.decodeString(null);
            }
            case "DateTime": {
                return this.decodeDateTime(null);
            }
            case "Guid": {
                return this.decodeGuid(null);
            }
            case "ByteString": {
                return this.decodeByteString(null);
            }
            case "XmlElement": {
                return this.decodeXmlElement(null);
            }
            case "NodeId": {
                return this.decodeNodeId(null);
            }
            case "ExpandedNodeId": {
                return this.decodeExpandedNodeId(null);
            }
            case "StatusCode": {
                return this.decodeStatusCode(null);
            }
            case "QualifiedName": {
                return this.decodeQualifiedName(null);
            }
            case "LocalizedText": {
                return this.decodeLocalizedText(null);
            }
            case "ExtensionObject": {
                return this.decodeExtensionObject(null);
            }
            case "DataValue": {
                return this.decodeDataValue(null);
            }
            case "Variant": {
                return this.decodeVariant(null);
            }
            case "DiagnosticInfo": {
                return this.decodeDiagnosticInfo(null);
            }
        }
        throw new UaSerializationException(0x80070000L, "unknown builtin type: " + type);
    }

    @Override
    public DiagnosticInfo decodeDiagnosticInfo(String field) {
        int symbolicId = -1;
        int namespaceUri = -1;
        int localizedText = -1;
        int locale = -1;
        String additionalInfo = null;
        StatusCode innerStatusCode = null;
        DiagnosticInfo innerDiagnosticInfo = null;
        if (this.nextStartElement("SymbolicId")) {
            symbolicId = this.decodeInt32(null);
            this.requireNextEndElement("SymbolicId");
        }
        if (this.nextStartElement("NamespaceUri")) {
            namespaceUri = this.decodeInt32(null);
            this.requireNextEndElement("NamespaceUri");
        }
        if (this.nextStartElement("LocalizedText")) {
            localizedText = this.decodeInt32(null);
            this.requireNextEndElement("LocalizedText");
        }
        if (this.nextStartElement("Locale")) {
            locale = this.decodeInt32(null);
            this.requireNextEndElement("Locale");
        }
        if (this.nextStartElement("AdditionalInfo")) {
            additionalInfo = this.decodeString(null);
            this.requireNextEndElement("AdditionalInfo");
        }
        if (this.nextStartElement("InnerStatusCode")) {
            innerStatusCode = this.decodeStatusCode(null);
            this.requireNextEndElement("InnerStatusCode");
        }
        if (this.nextStartElement("InnerDiagnosticInfo")) {
            innerDiagnosticInfo = this.decodeDiagnosticInfo(null);
            this.requireNextEndElement("InnerDiagnosticInfo");
        }
        return new DiagnosticInfo(namespaceUri, symbolicId, locale, localizedText, additionalInfo, innerStatusCode, innerDiagnosticInfo);
    }

    @Override
    public <T extends UaStructure> T decodeMessage(String field) {
        return null;
    }

    @Override
    public <T extends UaEnumeration> T decodeEnumeration(String field, Class<T> clazz) throws UaSerializationException {
        return (T)this.parseElement(field, content -> {
            int separator = content.lastIndexOf(95);
            String name = separator < 1 ? content : content.substring(0, separator);
            Enum enumInstance = Enum.valueOf(clazz.asSubclass(Enum.class), name);
            return (UaEnumeration)clazz.cast(enumInstance);
        });
    }

    @Override
    public <T extends UaSerializable> T decodeSerializable(String field, Class<T> clazz) {
        return null;
    }

    @Override
    public <T> T[] decodeArray(String field, Function<String, T> decoder, Class<T> clazz) {
        return null;
    }

    @Override
    public <T> T[] decodeArray(String field, BiFunction<String, Class<T>, T> decoder, Class<T> clazz) {
        return null;
    }

    private <T> T parseElement(String element, Function<String, T> parser) throws UaSerializationException {
        this.requireNextStartElement(element);
        T parsed = parser.apply(this.readCharacterContent());
        this.requireNextEndElement(element);
        return parsed;
    }

    private <T> T parseNillableElement(String element, Function<String, T> parser) throws UaSerializationException {
        this.requireNextStartElement(element);
        String nilValue = this.streamReader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
        T parsed = nilValue != null && Boolean.parseBoolean(nilValue) ? parser.apply(null) : parser.apply(this.readCharacterContent());
        this.requireNextEndElement(element);
        return parsed;
    }

    private String getNextStartElement() throws UaSerializationException {
        try {
            this.streamReader.nextTag();
            if (this.streamReader.getEventType() == 1) {
                return this.streamReader.getLocalName();
            }
            throw new UaSerializationException(0x80070000L, "expected start element");
        }
        catch (XMLStreamException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }

    private boolean nextStartElement(String element) throws UaSerializationException {
        try {
            if (element == null || element.isEmpty()) {
                return true;
            }
            this.streamReader.nextTag();
            return this.streamReader.getEventType() == 1 && element.equals(this.streamReader.getLocalName());
        }
        catch (XMLStreamException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }

    private void requireNextStartElement(String element) throws UaSerializationException {
        if (!this.nextStartElement(element)) {
            throw new UaSerializationException(0x80070000L, "start of element '" + element + "' not found");
        }
    }

    private boolean nextEndElement(String element) throws UaSerializationException {
        try {
            if (element == null || element.isEmpty()) {
                return true;
            }
            this.streamReader.nextTag();
            return this.streamReader.getEventType() == 2 && element.equals(this.streamReader.getLocalName());
        }
        catch (XMLStreamException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }

    private void requireNextEndElement(String element) throws UaSerializationException {
        if (!this.nextEndElement(element)) {
            throw new UaSerializationException(0x80070000L, "end of element '" + element + "' not found");
        }
    }

    private boolean currentElement(String element) {
        return element.equals(this.streamReader.getLocalName());
    }

    private void requireCurrentElement(String element) throws UaSerializationException {
        if (!this.currentElement(element)) {
            throw new UaSerializationException(0x80070000L, "expected current element '" + element + "'");
        }
    }

    private String readCharacterContent() throws UaSerializationException {
        try {
            while (this.streamReader.hasNext()) {
                this.streamReader.next();
                if (this.streamReader.getEventType() != 4) continue;
                return this.streamReader.getText();
            }
            throw new UaSerializationException(0x80070000L, "no character content found");
        }
        catch (XMLStreamException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }

    private Optional<String> readElementText() throws UaSerializationException {
        try {
            if (!this.streamReader.isStartElement() && !this.streamReader.isEndElement()) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.streamReader.getElementText());
        }
        catch (XMLStreamException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }
}

